package org.nuiton.jaxx.plugin;

import jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import org.apache.maven.plugin.MojoFailureException;

import java.io.File;
import java.util.Locale;
import java.util.Set;

/**
 * Generate the help ids files from the previous jaxx generation.
 * 
 * Created: 22 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @author chemit
 * @version $Revision: 1699 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-23 09:58:07 +0100 (mer., 23 déc. 2009) $ par :
 *          $Author: tchemit $
 * @goal generate-help-ids
 * @phase process-sources
 * @requiresProject
 * @since 2.0.0
 */
public class GenerateHelpIdsMojo extends AbstractGenerateHelpMojo {

    @Override
    public boolean init() throws Exception {
        if (!generateHelp) {

            return true;
        }

        if (!super.init()) {
            return false;
        }

        // check there is some bundle
        if (getHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStore' property.");
        }
        if (getMergeHelpIdsFilename() == null) {
            throw new MojoFailureException("you must set the 'helpIdStoreAll' property.");
        }

        return true;
    }

    @Override
    public void doAction() throws Exception {

        if (skipAction()) {
            return;
        }

        Set<String> helpIds = HelpRootCompiledObjectDecorator.getHelpIds();

        if (helpIds.isEmpty()) {
//            if (isVerbose()) {
            // no ids detected in this compilation round
            getLog().info("No helpIds detected.");
//            }
            cleanHelpIdsStore();
            return;
        }

        // store current jaxx session detected help ids

        File idsStore = getHelpIdsStoreFile();
        getLog().info("Store detected help ids to " + idsStore);

        storeHelpIds(idsStore, helpIds);

        // store merged help ids (to make possible a force on help generation)


        File idsStoreAll = getMergeHelpIdsStoreFile();
        getLog().info("Merge help ids to " + idsStoreAll);

        if (idsStoreAll.exists()) {
            Set<String> allIds = loadHelpIds(idsStoreAll);
            helpIds.addAll(allIds);
            allIds.clear();
        }

        storeHelpIds(idsStoreAll, helpIds);

        helpIds.clear();

    }

    @Override
    protected void doActionForLocale(Locale locale, boolean isDefaultLocale, File source, String localePath) throws Exception {
    }

    @Override
    protected void postDoAction() {
    }

    @Override
    public File getTargetDirectory() {
        return getOutputHelpIds();
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        setOutputHelpIds(targetDirectory);
    }
}
