/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jaxx.beaninfos.BeanInfoUtil;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerOptions;
import jaxx.compiler.HelpRootCompiledObjectDecorator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerLaunchor;
import jaxx.runtime.JAXXContext;
import jaxx.tags.TagManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.nuiton.jaxx.AbstractJaxxMojo;
import org.nuiton.util.FileUpdaterHelper;
import org.nuiton.util.MirroredFileUpdater;

public class JaxxGeneratorMojo
extends AbstractJaxxMojo {
    protected String compilerFQN;
    protected String validatorFQN;
    protected File outResource;
    protected File outClass;
    protected File src;
    protected boolean optimize;
    protected String javaOpts = null;
    protected String[] includes;
    protected String[] excludes;
    protected boolean addSourcesToClassPath;
    protected boolean addResourcesToClassPath;
    protected boolean addCompileClassPath;
    protected boolean addProjectClassPath;
    protected boolean force;
    protected boolean addLogger;
    protected boolean resetAfterCompile;
    protected String jaxxContextImplementorClass;
    protected String[] beanInfoSearchPath;
    protected String[] extraImports;
    protected String extraImportList;
    protected String defaultErrorUIFQN;
    protected String defaultDecoratorFQN;
    protected boolean useUIManagerForIcon;
    protected boolean profile;
    protected boolean generateHelp;
    protected String helpBrokerFQN;
    protected boolean testPhase;
    protected String[] files;
    private static final String[] INCLUDES = new String[]{"**\\/*.jaxx"};
    protected CompilerOptions options;
    protected MirroredFileUpdater updater;
    private Class<?> defaultErrorUIClass;
    private Class<?> validatorClass;
    private Class<? extends CompiledObjectDecorator> defaultDecoratorClass;
    private Class<? extends JAXXCompiler> compilerClass;

    @Override
    public void init() throws Exception {
        if (this.project != null && ("pom".equals(this.project.getPackaging()) || "site".equals(this.project.getPackaging()))) {
            this.skip = true;
            this.getLog().info((CharSequence)("skip generate goal for packaging " + this.project.getPackaging()));
            return;
        }
        if (this.generateHelp && this.helpIdStore == null) {
            throw new MojoFailureException("you must set the helpIdStore property.");
        }
        this.skip = false;
        this.checkJaxxContextImplementorClass();
        if (this.beanInfoSearchPath != null && this.beanInfoSearchPath.length > 0) {
            BeanInfoUtil.addJaxxBeanInfoPath((String[])this.beanInfoSearchPath);
        }
        if (!this.outResource.exists()) {
            this.outResource.mkdirs();
        }
        if (!this.outJava.exists()) {
            this.outJava.mkdirs();
        }
        this.fixCompileSourceRoots();
        if (this.addSourcesToClassPath || this.addProjectClassPath) {
            this.cl = this.initClassLoader(this.project, this.getLog());
            Thread.currentThread().setContextClassLoader(this.cl);
        } else {
            this.cl = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this.compilerClass = Class.forName(this.compilerFQN, false, this.cl);
        this.defaultDecoratorClass = Class.forName(this.defaultDecoratorFQN, false, this.cl);
        this.validatorClass = Class.forName(this.validatorFQN, false, this.cl);
        if (this.defaultErrorUIFQN != null && !this.defaultErrorUIFQN.trim().isEmpty()) {
            this.defaultErrorUIClass = Class.forName(this.defaultErrorUIFQN, false, this.cl);
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.src);
        boolean noIncludes = this.includes == null || this.includes.length == 0;
        ds.setIncludes(noIncludes ? INCLUDES : this.includes);
        if (this.excludes != null && this.excludes.length > 0) {
            ds.setExcludes(this.excludes);
        }
        ds.scan();
        String[] filesFind = ds.getIncludedFiles();
        if (this.verbose) {
            this.getLog().info((CharSequence)("jaxx - discover " + filesFind.length + " jaxx file(s). "));
        }
        this.updater = FileUpdaterHelper.newJaxxFileUpdater((File)this.src, (File)this.outJava);
        if (this.force) {
            this.files = filesFind;
        } else {
            ArrayList<String> listFiles = new ArrayList<String>();
            for (String file : filesFind) {
                if (this.updater.isFileUpToDate(new File(this.src, file))) {
                    if (!this.verbose) continue;
                    this.getLog().info((CharSequence)("jaxx - skip file [" + file + "]."));
                    continue;
                }
                if (this.verbose) {
                    this.getLog().info((CharSequence)("jaxx - detect modify file [" + file + "]."));
                }
                listFiles.add(file);
            }
            this.files = listFiles.toArray(new String[listFiles.size()]);
        }
        if (this.extraImportList != null && !this.extraImportList.isEmpty()) {
            Object[] imports = this.extraImportList.split(",");
            int i = 0;
            for (String string : imports) {
                imports[i++] = string.trim();
            }
            if (this.verbose) {
                this.getLog().info((CharSequence)("extra imports " + Arrays.toString(imports)));
            }
            this.extraImports = imports;
        }
        this.options = this.toCompilerOptions();
        if (this.verbose) {
            this.printInit();
        }
    }

    @Override
    public void doAction() throws MojoExecutionException {
        this.getLog().info((CharSequence)("jaxx - detects " + this.files.length + " modify jaxx file(s). "));
        try {
            TagManager.reset((boolean)this.verbose);
            JAXXCompilerLaunchor launchor = JAXXCompilerLaunchor.newLaunchor((File)this.src, (String[])this.files, (CompilerOptions)this.options);
            boolean success = launchor.compile();
            this.getLog().info((CharSequence)("jaxx - generate " + launchor.getCompilerCount() + " file(s). "));
            if (!success) {
                throw new MojoExecutionException("Aborting due to errors reported by jaxxc");
            }
            if (this.generateHelp) {
                this.generateHelp();
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Throwable e2 = e;
            while (e2.getCause() != null) {
                e2 = e.getCause();
            }
            this.getLog().error(e2);
            throw new MojoExecutionException(e2.getMessage(), e2);
        }
    }

    public CompilerOptions toCompilerOptions() {
        CompilerOptions result = new CompilerOptions();
        result.setClassPath(this.src.getPath());
        if (this.javaOpts != null && !"".equals(this.javaOpts)) {
            result.setJavacOpts(this.javaOpts);
        }
        result.setCompilerClass(this.compilerClass);
        result.setValidatorFQN(this.validatorFQN);
        result.setValidatorClass(this.validatorClass);
        result.setKeepJavaFiles(true);
        result.setOptimize(this.optimize);
        result.setJavacTargetDirectory(this.outClass);
        result.setTargetDirectory(this.outJava);
        result.setVerbose(this.verbose);
        result.setI18nable(this.i18nable);
        result.setAddLogger(this.addLogger);
        result.setProfile(this.profile);
        result.setResetAfterCompile(this.resetAfterCompile);
        result.setJaxxContextImplementorClass(this.jaxxContextImplementorClass);
        result.setExtraImports(this.extraImports);
        result.setDefaultErrorUI(this.defaultErrorUIClass);
        result.setUseUIManagerForIcon(this.useUIManagerForIcon);
        result.setDefaultDecoratorClass(this.defaultDecoratorClass);
        result.setGenerateHelp(this.generateHelp);
        result.setHelpBrokerFQN(this.helpBrokerFQN);
        result.setHelpsetTitleI18nSuffix(this.helpsetTitleI18nSuffix);
        result.setHelpsetIndexI18nSuffix(this.helpsetIndexI18nSuffix);
        result.setHelpsetTocI18nSuffix(this.helpsetTocI18nSuffix);
        result.setHelpSetName(this.helpSetName);
        result.setHelpsetI18nPrefix(this.helpsetI18nPrefix);
        if (this.cl != null) {
            result.setClassLoader(this.cl);
        }
        return result;
    }

    protected void fixCompileSourceRoots() {
        if (this.project == null) {
            return;
        }
        if (this.testPhase) {
            if (!this.project.getTestCompileSourceRoots().contains(this.outJava.getPath())) {
                this.getLog().info((CharSequence)("Add test compile source root : " + this.outJava));
                this.project.addTestCompileSourceRoot(this.outJava.getPath());
            }
        } else if (!this.project.getCompileSourceRoots().contains(this.outJava.getPath())) {
            this.getLog().info((CharSequence)("Add compile source root : " + this.outJava));
            this.project.addCompileSourceRoot(this.outJava.getPath());
        }
    }

    protected void printInit() {
        this.getLog().info((CharSequence)this.options.toString());
        this.getLog().info((CharSequence)("includes : " + Arrays.toString(this.includes)));
        for (String file : this.files) {
            this.getLog().info((CharSequence)("will generate " + file));
        }
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        this.getLog().info((CharSequence)threadLoader.toString());
        if (threadLoader.getClass().getSimpleName().equals("RealmClassLoader")) {
            try {
                URL[] urls;
                Method m = threadLoader.getClass().getDeclaredMethod("getURLs", new Class[0]);
                m.setAccessible(true);
                for (URL url : urls = (URL[])m.invoke((Object)threadLoader, new Object[0])) {
                    this.getLog().info((CharSequence)("url in class loader " + url));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("??? : " + e.getMessage()), (Throwable)e);
            }
        }
        if (this.getPluginContext() != null) {
            for (Object e : this.getPluginContext().keySet()) {
                this.getLog().info((CharSequence)("pluginContext " + e + " : " + this.getPluginContext().get(e)));
            }
        }
    }

    protected void checkJaxxContextImplementorClass() {
        if (this.jaxxContextImplementorClass == null) {
            throw new IllegalArgumentException("jaxxContextImplementor can not be null");
        }
        try {
            Class<?> jaxxContextImplementor = Class.forName(this.jaxxContextImplementorClass);
            if (!JAXXContext.class.isAssignableFrom(jaxxContextImplementor)) {
                throw new IllegalArgumentException("jaxxContextImplementor '" + jaxxContextImplementor + "' does not implements " + JAXXContext.class);
            }
            if (Modifier.isAbstract(jaxxContextImplementor.getModifiers())) {
                throw new IllegalArgumentException("jaxxContextImplementor '" + jaxxContextImplementor + "' can not be abstract.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("could not find jaxxContextImplementor class : " + this.jaxxContextImplementorClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateHelp() throws IOException {
        Set helpIds = HelpRootCompiledObjectDecorator.getHelpIds();
        if (helpIds.isEmpty()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"no helpIds detected.");
            }
            return;
        }
        if (!this.helpIdStore.getParentFile().exists()) {
            this.helpIdStore.getParentFile().mkdirs();
        }
        Properties p = new Properties();
        for (String helpId : helpIds) {
            String path = helpId.replaceAll("\\.", File.separator);
            path = this.removeQuote(path) + ".html";
            p.put(this.removeQuote(helpId), path);
        }
        FileOutputStream w = new FileOutputStream(this.helpIdStore);
        try {
            p.store(w, null);
        }
        finally {
            w.close();
        }
        this.getLog().info((CharSequence)("helpIdStore generated in " + this.helpIdStore));
        helpIds.clear();
    }

    protected URLClassLoader initClassLoader(MavenProject project, Log log) throws MalformedURLException {
        URLClassLoader loader = null;
        if (project != null) {
            URLClassLoader result;
            try {
                ArrayList<URL> lUrls = new ArrayList<URL>();
                List sources = project.getCompileSourceRoots();
                if (this.addSourcesToClassPath) {
                    for (String source : sources) {
                        lUrls.add(new File(source).toURI().toURL());
                    }
                    if (this.testPhase) {
                        for (String source : project.getTestCompileSourceRoots()) {
                            lUrls.add(new File(source.toString()).toURI().toURL());
                        }
                    }
                }
                if (this.addResourcesToClassPath) {
                    for (String source : project.getResources()) {
                        Resource r = (Resource)source;
                        lUrls.add(new File(r.getDirectory()).toURI().toURL());
                    }
                }
                if (this.testPhase && this.addCompileClassPath && project != null) {
                    lUrls.add(new File(project.getBuild().getOutputDirectory()).toURI().toURL());
                }
                if (this.addProjectClassPath) {
                    this.getLog().info((CharSequence)"use project compile scope class-path");
                    Set artifacts = project.getArtifacts();
                    for (Object o : artifacts) {
                        Artifact a = (Artifact)o;
                        lUrls.add(a.getFile().toURI().toURL());
                    }
                }
                result = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e) {
                throw new RuntimeException("Can't create ClassLoader for reason " + e.getMessage(), e);
            }
            loader = result;
        } else {
            ArrayList<URL> lUrls = new ArrayList<URL>();
            if (this.addSourcesToClassPath) {
                lUrls.add(this.src.toURI().toURL());
            }
            loader = new URLClassLoader(lUrls.toArray(new URL[lUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (this.verbose) {
            for (URL entry : loader.getURLs()) {
                log.info((CharSequence)("classpath : " + entry));
            }
        }
        return loader;
    }

    protected String removeQuote(String txt) {
        if (txt.startsWith("\"")) {
            txt = txt.substring(1);
        }
        if (txt.endsWith("\"")) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }
}

