/*
 * #%L
 * JAXX :: Tutorial Data-binding
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 Nuiton
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jaxx.tutorials.databinding;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class databinding extends Application implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD = "$JSlider0.style.$JSlider0.getValue() > 100.add";
    private static final String BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE = "$JSlider0.style.$JSlider0.getValue() > 100.remove";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRR+rf1hwR9IAwFFsyIHSHBbzhBASxolVRNLDLEXp91JGZzujDOzsoZg/BP8E/TuxcSbJ+PBswcvxn/BGA9ejW+22xbsGkjcw2Tz5r3vfe993+6b75DVCq7ukjB0VeAb1qHu5o3t7XvNXdoyG1S3FJNGKOg+qTSkGzDq9ePawLVGzZaX4vJSRXSk8Kl/qHq5BiPaPONU71BqDFw+WtHSulTvXy+HMlA91D6pJNRXP3+kX3ovXqcBQonsMjiKc1zVYJJMDdLMMzCOnZ6SEid+G2ko5reR71kbq3Ci9V3SoU/gOeRrkJNEIZiB2ZOPHGFE9aE0kDGBEQaWhGq7fsCM8N2IsA0rRrh2PWJIk/ke0jj8LmUEkjNQMDQ0VUY5Up+0LENX79nsza3ehc0sDArmNm8GBluVDRSPFHTDQ9l1zjyqhrK74ThbwaUjm0YN3YGGgyWnGpBVAYYNTDWGZb+PV13Bp/4S3AJGt78ni1/ef3tX7amcw94TiamHTIrbl0pIqgyzrc93JQ4M46U7RC43oKApR4dHDp5JIFaPr5Ec9rtgy11b7t4iegchsvmvHz5OPvp8CtJVGOGCeFVi82+jPjsKtyC4F8q19YjRmb3TeI5ZbgayhhmOK5rYQHWvx/I6W7EBQlzFTMIq+nyahU+/ivW36711pJDe9D/TByvJPoQc8znzaWT72NGJNh+VmgaeGDg3ycsQm1nGzrwYnVeSJs5Yx+LgFS40DQObNxsxt29zCJRrRkY8AdRIk7Qet5UIfHT/7L5P95yK4ELNi+iH5bapeUB4QOcXFsuL5YWD4W74EeZjKxuY3h+qc1adpXL54FgmeeqTJqdI49yK/U6dWMnVoZYpe46dfE/jK12dHGLwb4Srof+Bme+QkHWCjk1YS4YpIswf0bEd1wkGAAA=";
    private static final Log log = LogFactory.getLog(databinding.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField textField;
    protected databinding tuto = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JSlider $JSlider0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public databinding() {
        $initialize();
    }

    public databinding(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public databinding(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public databinding(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public databinding(String param0) {
        super(param0);
        $initialize();
    }

    public databinding(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public databinding(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public databinding(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    public static void main(String[] arg) {
        SwingUtilities.invokeLater(new Runnable() { public void run() { new databinding().setVisible(true); } });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getTextField() {
        return textField;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JSlider get$JSlider0() {
        return $JSlider0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTuto() {
        if (!allComponentsCreated) {
            return;
        }
        add(textField, BorderLayout.NORTH);
        add($JButton0, BorderLayout.SOUTH);
        add($JSlider0);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTuto();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        tuto.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("tuto", tuto);
        createTextField();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Button"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JSlider0
        $objectMap.put("$JSlider0", $JSlider0 = new JSlider());
        
        $JSlider0.setName("$JSlider0");
        $JSlider0.setValue(0);
        $JSlider0.setMaximum(200);
        // inline creation of tuto
        setName("tuto");
        setDefaultCloseOperation(3);
        setTitle(_("Data-binding Tutorial"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (textField != null) {
                    $bindingSources.put("textField.getDocument()", textField.getDocument());
                    textField.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    textField.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (textField != null && textField.getText() != null) {
                    $JButton0.setEnabled(textField.getText().length() != 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (textField != null) {
                    Document $target = (Document) $bindingSources.remove("textField.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    textField.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD, true) {
        
            @Override
            public void applyDataBinding() {
                if ($JSlider0 != null) {
                    $bindingSources.put("$JSlider0.getModel()", $JSlider0.getModel());
                    $JSlider0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    $JSlider0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD));
                }
            }
        
            @Override
            public void processDataBinding() {
                if ($JSlider0.getValue() > 100) {
                    Object value = Pseudoclasses.applyProperty(databinding.this, $JSlider0, "background", new DataBinding("$JSlider0.background.0"), Pseudoclasses.wrap($JSlider0.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        $JSlider0.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if ($JSlider0 != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("$JSlider0.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    $JSlider0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_ADD));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE, true) {
        
            @Override
            public void applyDataBinding() {
                if ($JSlider0 != null) {
                    $bindingSources.put("$JSlider0.getModel()", $JSlider0.getModel());
                    $JSlider0.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    $JSlider0.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (!($JSlider0.getValue() > 100)) {
                    Object value = Pseudoclasses.removeProperty(databinding.this, $JSlider0, "background", new DataBinding("$JSlider0.background.0"), Pseudoclasses.wrap($JSlider0.getBackground()), 0);
                    if (!(value instanceof DataBinding)) {
                        $JSlider0.setBackground((Color) value);
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if ($JSlider0 != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("$JSlider0.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    $JSlider0.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.tutorials.databinding.databinding.this, BINDING_$JSLIDER0_STYLE_$JSLIDER0_GET_VALUE_100_REMOVE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}