package jaxx.runtime;

/**
 * This is the contract to be realized by any class to be used as Action class for an ui.
 *
 * @author chemit
 */
public interface JAXXAction {

    /**
     * Prepare the initial context of the ui.
     *
     * @param parentContent the context of the parent of the ui (can be null if no parent is required)
     * @param datas         other datas to inject in initial context
     * @return the {@link jaxx.runtime.JAXXInitialContext} to be injected in the ui via the constructor of the {@link jaxx.runtime.JAXXObject}
     */
    JAXXInitialContext init(JAXXContext parentContent, Object... datas);

}
