package org.nuiton.jaxx.demo.component.jaxx.widgets.gis;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;

public class CoordinatesEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uy04UQRStGZxBHoKCj6UkoJgo3RJfC4wPXlEygIKJhNlYM1V2F9ZUlVXVTrNh4cKdP+DCrRvDPxBXJm7c8g8mfIK3upsZBmbwOYvqnqpzT517+t77+QcqGI2uSR14ImJWCm8Dx7GnI2FZjXoLD9fWlisbtGpnqalqpqzUKP3l8ihfRn2ksW8s8solYPJTJt8x+RmTPyNrSgoqDhBNlVCvsZucmpBSa9GVjsFVY/zVBnIqVpHO7mqrut1d395N7ubo7Ic8QrEC+f2Q9tU/IGhmfaKE8oxYNFTawG+wz7EIQJxmIoCETrm9GY6NWcI1+hptoe4SKiqsgcyiib+yJ6FLqGJlUd/YLK3JJ1hQft2iucMpEDj0qvts6V6dkYBa4wXMQGpSEyawpWaOQJh2bEol/EWLCjVJKLdo4b/wLjqyJnn32DNc4RRkj3Zy3tTBRy+BuaCeRmyxKsVLFoDtzuE4Ay4kPjjIYAPZY0JZX6HGldS5FvBMSKuvpmXsgEMNfD8V7rrpyIIat3eh9XyYMKM43lynWj4PqViKOG8DK9IkbYtuH87toE24YiSPLD3qV2sSRU1NxK37d7b1ZCA9eRphorErqlZDSriSGnLxcEQJW2Yjkvg62ooYzBBSBEcgGl3u9LGgLb1mWzY7JFdGBR3BNnzozhPBNfUKoNJ2Hu3czu6aBPh2e0t/qu/t7vdwF4gb+VXUgXEFDaW0VFRb5rQNpg0cWcb9RaymylA6lMOsS2bZ+PHKVzMkqAcVZxyT55i8R9iEwFbo3t35cv7F9y6Un0e9XGIyjx3+MeqxIdgdSk5idf9BIq6/fhLW004mfHqoNQnFiAbuEmzxSIUJKJTgXgwujR/vUkPU9vLe14/vL+3sO5UDjWO/E9l0q7COikxwJmgy77JR1na+9SlDIyKbc6rd5Mq5Z6/KpsFEsk4ezd9t33DLzThyj1uJevd2Jzkb/meGEWD4CaF3SBj4BgAA";
    private static final Log log = LogFactory.getLog(CoordinatesEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected JCheckBox displayZeroWhenNull;
    protected CoordinatesEditor editor;
    protected JCheckBox enableButton;
    protected CoordinatesEditorDemoHandler handler;
    protected CoordinatesEditorDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;
    protected JLabel resultQuadrant;
    protected JCheckBox showReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinatesEditorDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CoordinatesEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo() {
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public JCheckBox getDisplayZeroWhenNull() {
        return displayZeroWhenNull;
    }

    public CoordinatesEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public CoordinatesEditorDemoHandler getHandler() {
        return handler;
    }

    public CoordinatesEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    public JLabel getResultQuadrant() {
        return resultQuadrant;
    }

    public JCheckBox getShowReset() {
        return showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        config.add(showReset);
        config.add(enableButton);
        config.add(displayZeroWhenNull);
    }

    protected void addChildrenToResult() {
        result.add(resultQuadrant);
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(0,1));
    }

    protected void createDisplayZeroWhenNull() {
        $objectMap.put("displayZeroWhenNull", displayZeroWhenNull = new JCheckBox());
        
        displayZeroWhenNull.setName("displayZeroWhenNull");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new CoordinatesEditor());
        
        editor.setName("editor");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    protected void createResultQuadrant() {
        $objectMap.put("resultQuadrant", resultQuadrant = new JLabel());
        
        resultQuadrant.setName("resultQuadrant");
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = new JCheckBox());
        
        showReset.setName("showReset");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new CoordinatesEditorDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createShowReset();
        createEnableButton();
        createDisplayZeroWhenNull();
        createEditor();
        createResult();
        createResultQuadrant();
        createResultLatitude();
        createResultLongitude();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToResult();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}