/*
 * *##% 
 * I18n :: Api
 * Copyright (C) 2004 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.i18n.bundle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.init.I18nInitializer;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

/**
 * Classe qui est responsable de la detection et construction de {@link
 * I18nBundle}.
 * <p/>
 * On retrouve aussi ici des méthodes utiles de parcours de bundles.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.6
 * @deprecated since 1.1, prefer use the {@link I18nBundleUtil} class instead.
 */
@Deprecated
public class I18nBundleFactory extends I18nBundleUtil {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(I18nBundleFactory.class);

    protected static String UNIQUE_BUNDLE_PATH = "/META-INF/";

    public static String UNIQUE_BUNDLE_DEF = "%1$s-definition.properties";

    public static String UNIQUE_BUNDLE_ENTRY = "%1$s-%2$s.properties";

    public static String BUNDLE_DEF_LOCALES = "locales";

    public static String BUNDLES_FOR_LOCALE = "bundles.";

    /**
     * Recherche la liste des url de toutes les resources i18n, i.e les urls des
     * fichiers de traduction en mode uniqueBundleName.
     * <p/>
     * On va d'abord rechercher un fichier /META-INF/unqiueBundleName-definition.properties
     * <p/>
     * Dans ce fichier il y a une entree locales qui contient les locales du
     * bundle
     * <p/>
     * Ensuite pour chaque locale on recupere l'url du fichier :
     * <p/>
     * /META-INF/uniqueBundleName-locale.properties
     * <p/>
     * Exemple :
     * <p/>
     * <code> fichier de définition : /META-INF/monAppli-definition.properties
     * locales=fr_fr,es_ES
     * <p/>
     * fichiers de traduction /META-INF/monAppli-fr_FR.properties
     * /META-INF/monAppli-es_ES.properties
     * <p/>
     * </code>
     *
     * @param uniqueBundleName le nom de l'unique bundle a charger
     * @return la liste des urls de bundle i18n
     * @deprecated since 1.1, prefer use the {@link I18nInitializer} api
     *             instead.
     */
    @Deprecated
    public static URL[] getURLs(String uniqueBundleName) {
        String definitionFileName = String.format(UNIQUE_BUNDLE_DEF,
                                                  uniqueBundleName);
        URL[] urls;

        try {
            URL defURL = I18nBundleFactory.class.getResource(
                    UNIQUE_BUNDLE_PATH + definitionFileName);
            Properties p = loadUniqueNameDefFile(uniqueBundleName);

            String localesAsStr = p.getProperty(BUNDLE_DEF_LOCALES);
            Locale[] locales = I18nUtil.parseLocales(localesAsStr);
            List<URL> lUrls = new ArrayList<URL>(1);
            String prefixURL = defURL.toString();
            prefixURL = prefixURL.substring(0, prefixURL.length() -
                                               definitionFileName.length());
            //FIXME on devrait tester que la resource est disponible ?

            for (Locale l : locales) {
                String url = prefixURL + String.format(UNIQUE_BUNDLE_ENTRY,
                                                       uniqueBundleName,
                                                       l.toString());
                log.info("detected bundle properties file : " + url);
                URL u = new URL(url);
//                //FIXME on devrait tester que la resource est disponible ?

                lUrls.add(u);
            }
            if (!lUrls.isEmpty()) {
                urls = lUrls.toArray(new URL[lUrls.size()]);
            } else {
                // l'unique bundle n'a pas ete trouve!
                // on utilise la methode classique de chargement avec recherche
                // de tous les bundles i18n
                log.warn("not bundle files detected in " + prefixURL);
                urls = null;
            }

        } catch (Exception ex) {
            log.warn("could not load unique bundle " + uniqueBundleName +
                     " for reason " + ex.getMessage(), ex);
            urls = null;

        }
        return urls;
    }

    /**
     * @param uniqueBundleName the unique bundle name
     * @return the properties file loaded
     * @deprecated since 1.1, prefer use the {@link I18nInitializer} api
     *             instead.
     */
    @Deprecated
    public static Properties loadUniqueNameDefFile(String uniqueBundleName) {
        String definitionFileName = String.format(UNIQUE_BUNDLE_DEF,
                                                  uniqueBundleName);
        Properties p = new Properties();
        try {
            URL defURL = I18nBundleFactory.class.getResource(
                    UNIQUE_BUNDLE_PATH + definitionFileName);
            log.info("definition i18n file : " + defURL);
            InputStream stream = defURL.openStream();
            p.load(stream);
            stream.close();
        } catch (Exception ex) {
            log.warn("could not load unique bundle " + uniqueBundleName +
                     " for reason " + ex.getMessage(), ex);
        }
        return p;
    }

}
