/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.init;

import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;

public abstract class I18nInitializer {
    private static final Log log = LogFactory.getLog(I18nInitializer.class);

    public abstract I18nBundle[] resolvBundles() throws Exception;

    public I18nBundle[] resolvBundles(URL ... urls) throws Exception {
        List<I18nBundle> bundles = I18nBundleUtil.detectBundles(urls);
        I18nBundle[] result = bundles.toArray(new I18nBundle[bundles.size()]);
        if (log.isInfoEnabled()) {
            I18nBundleEntry[] entries = I18nBundleUtil.getBundleEntries(result);
            log.info((Object)(bundles.size() + " bundle(s) found, in " + entries.length + " file(s)."));
        }
        return result;
    }
}

