/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.SortedProperties;

public class ParserJavaMojo
extends AbstractI18nParserMojo {
    protected File defaultBasedir;
    protected String defaultIncludes;
    protected String outputGetter;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater((File)entry.getBasedir(), (File)this.cp);
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser() {
        return new JavaFileParser(this.getLog(), this.encoding, this.oldParser, this.isShowTouchedFiles());
    }

    protected static class JavaFileParser
    extends AbstractFileParser {
        protected final Pattern i18nPattern = Pattern.compile("(?:^_\\(\\s*\\\"|[^l]_\\(\\s*\\\"|l_\\([^,]+\\s*,\\s*\\\")(.*?)\"");

        public JavaFileParser(Log log, String encoding, SortedProperties oldParser, boolean showTouchedFiles) {
            super(log, encoding, oldParser, showTouchedFiles);
        }

        public Pattern getI18nPattern() {
            return this.i18nPattern;
        }

        @Override
        public void parseFile(File file) throws IOException {
            String line = null;
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding()));
            try {
                while ((line = lnr.readLine()) != null) {
                    this.parseLine(file, line);
                }
            }
            catch (Exception e) {
                if (line != null) {
                    this.getLog().error((CharSequence)("could not parse line (" + lnr.getLineNumber() + ") '" + line + "' of file " + file));
                }
                throw new ParserException(e);
            }
            finally {
                lnr.close();
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
            Matcher matcher = this.i18nPattern.matcher(line);
            while (matcher.find()) {
                String key = matcher.group(1);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(file.getName() + " detected key = " + key));
                }
                this.setTouched(true);
                this.registerKey(key);
            }
        }
    }
}

