/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.nuiton.i18n.plugin.AbstractI18nMojo;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class GetterMojo
extends AbstractI18nMojo {
    protected boolean keepGetters;
    protected static final String FROM_GETTERS = "-fromGetters";

    protected boolean checkSkip() {
        if (!this.needGeneration()) {
            this.getLog().info((CharSequence)"No getter detected - all files are up to date.");
            return false;
        }
        return true;
    }

    protected void doAction() throws Exception {
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - basedir : " + this.out.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        File bundleGetters = new File(this.out.getAbsoluteFile(), this.artifactId + ".properties");
        this.createDirectoryIfNecessary(bundleGetters.getParentFile());
        SortedProperties propertiesOut = new SortedProperties(this.encoding);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.out);
        ds.setIncludes(new String[]{"*.getter"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (String file : files) {
            long t0 = System.nanoTime();
            File bundleGetter = this.getGetterFile(this.out, file, false);
            SortedProperties propertiesIn = new SortedProperties(this.encoding).load(bundleGetter);
            propertiesOut.putAll((Map)propertiesIn);
            if (!this.keepGetters) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Will delete getter " + bundleGetter));
                }
                this.deleteFile(bundleGetter);
            }
            if (this.silent) continue;
            String time = PluginHelper.convertTime((long)(System.nanoTime() - t0));
            this.getLog().info((CharSequence)("import getter " + bundleGetter.getName() + " in " + time));
        }
        propertiesOut.store(bundleGetters);
        for (Locale locale : this.locales) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("generate bundle for locale " + locale));
            }
            File bundleOut = this.getI18nFile(this.out, this.artifactId + FROM_GETTERS, locale, false);
            this.copyFile(bundleGetters, bundleOut);
            if (this.silent || !this.verbose) continue;
            this.getLog().info((CharSequence)("generate bundle " + locale));
        }
        if (!this.keepGetters) {
            this.deleteFile(bundleGetters);
        }
    }
}

