/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.model.GuixModelObject;

public abstract class JavaFileGenerator {
    protected Log log = LogFactory.getLog(JavaFileGenerator.class);
    protected List<String> imports = new ArrayList<String>();
    protected Map<String, JavaFile> classes = null;
    protected GuixModelObject gmo;
    protected JavaFile jf;

    public JavaFileGenerator(GuixModelObject gmo, Map<String, JavaFile> classes) {
        this.gmo = gmo;
        this.classes = classes;
    }

    public abstract JavaFile generate();

    protected abstract void addImports();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File out) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(out);
            fw.write(this.jf.toString("\n"));
            fw.close();
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)ex);
            }
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                this.log.error((Object)ex);
            }
        }
    }

    protected String getMethodName(Method m) {
        if (m == Method.BEFORE_BINDING) {
            return "beforeBinding";
        }
        if (m == Method.DATABINDING_INIT) {
            return "initDataBinding";
        }
        if (m == Method.BEFORE_TREE) {
            return "beforeTree";
        }
        if (m == Method.COMPONENTS_CREATION) {
            return "componentsCreation";
        }
        if (m == Method.BEFORE_SETTINGS) {
            return "beforeSetting";
        }
        if (m == Method.COMPONENTS_SETTINGS) {
            return "componentsSetting";
        }
        if (m == Method.BEFORE_CREATION) {
            return "beforeCreation";
        }
        if (m == Method.COMPONENTS_TREE) {
            return "componentsTree";
        }
        if (m == Method.IN_THE_END) {
            return "inTheEnd";
        }
        return null;
    }

    public static enum Method {
        COMPONENTS_CREATION,
        COMPONENTS_SETTINGS,
        COMPONENTS_TREE,
        DATABINDING_INIT,
        BEFORE_CREATION,
        BEFORE_TREE,
        BEFORE_SETTINGS,
        BEFORE_BINDING,
        IN_THE_END;

    }
}

