/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.selectors.AbstractSelectorContainer;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public class PathFileSet
extends DataType
implements ResourceCollection,
SelectorContainer {
    private Path clusterPath;
    private String include;
    private AbstractSelectorContainer selectors = new AbstractSelectorContainer(){};
    private ArrayList<FileResource> files;
    private List<Path> paths = new ArrayList<Path>();

    public void setInclude(String include) {
        this.include = include;
    }

    public void setPath(Path stringPath) {
        this.addPath(stringPath);
    }

    public void addPath(Path clusterPath) {
        this.paths.add(clusterPath);
    }

    public Enumeration selectorElements() {
        return this.selectors.selectorElements();
    }

    public int selectorCount() {
        return this.selectors.selectorCount();
    }

    public boolean hasSelectors() {
        return this.selectors.hasSelectors();
    }

    public FileSelector[] getSelectors(Project p) {
        return this.selectors.getSelectors(p);
    }

    public void appendSelector(FileSelector selector) {
        this.selectors.appendSelector(selector);
    }

    public void addType(TypeSelector selector) {
        this.selectors.addType(selector);
    }

    public void addSize(SizeSelector selector) {
        this.selectors.addSize(selector);
    }

    public void addSelector(SelectSelector selector) {
        this.selectors.addSelector(selector);
    }

    public void addPresent(PresentSelector selector) {
        this.selectors.addPresent(selector);
    }

    public void addOr(OrSelector selector) {
        this.selectors.addOr(selector);
    }

    public void addNot(NotSelector selector) {
        this.selectors.addNot(selector);
    }

    public void addNone(NoneSelector selector) {
        this.selectors.addNone(selector);
    }

    public void addModified(ModifiedSelector selector) {
        this.selectors.addModified(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.selectors.addMajority(selector);
    }

    public void addFilename(FilenameSelector selector) {
        this.selectors.addFilename(selector);
    }

    public void addDifferent(DifferentSelector selector) {
        this.selectors.addDifferent(selector);
    }

    public void addDepth(DepthSelector selector) {
        this.selectors.addDepth(selector);
    }

    public void addDepend(DependSelector selector) {
        this.selectors.addDepend(selector);
    }

    public void addDate(DateSelector selector) {
        this.selectors.addDate(selector);
    }

    public void addCustom(ExtendSelector selector) {
        this.selectors.addCustom(selector);
    }

    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.selectors.addContainsRegexp(selector);
    }

    public void addContains(ContainsSelector selector) {
        this.selectors.addContains(selector);
    }

    public void addAnd(AndSelector selector) {
        this.selectors.addAnd(selector);
    }

    public void add(FileSelector selector) {
        this.selectors.add(selector);
    }

    public Iterator iterator() {
        this.initFiles();
        return this.files.iterator();
    }

    public int size() {
        this.initFiles();
        return this.files.size();
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    private void initFiles() throws BuildException {
        if (this.files != null) {
            return;
        }
        try {
            this.files = new ArrayList();
            this.log("ClusterPathSet: scanning " + this.paths.size() + " paths.", 3);
            DirectoryScanner scanner = new DirectoryScanner();
            if (this.paths.size() == 0) {
                throw new BuildException("No path specified");
            }
            for (Path path : this.paths) {
                String[] includedClusters;
                for (String clusterName : includedClusters = path.list()) {
                    this.log("ClusterPathSet: scanning pathelement '" + clusterName + "'.", 3);
                    scanner.setBasedir(clusterName);
                    scanner.setSelectors(this.selectors.getSelectors(this.getProject()));
                    if (this.include != null) {
                        scanner.setIncludes(new String[]{this.include});
                    }
                    scanner.scan();
                    this.log("ClusterPathSet: " + scanner.getIncludedFilesCount() + " files found.", 3);
                    for (String relFile : scanner.getIncludedFiles()) {
                        this.files.add(new FileResource(scanner.getBasedir(), relFile));
                    }
                }
            }
        }
        catch (BuildException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

