/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.MakeNBM;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeUpdateDesc
extends MatchingTask {
    protected boolean usedMatchingTask = false;
    private List<Entityinclude> entityincludes = new ArrayList<Entityinclude>();
    private List<Group> groups = new ArrayList<Group>();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private File desc;
    private boolean automaticGrouping;
    private String dist_base;
    private boolean useLicenseUrl;
    private Path updaterJar;

    public void setDesc(File d) {
        this.desc = d;
    }

    public Group createGroup() {
        Group g = new Group();
        this.groups.add(g);
        return g;
    }

    public Entityinclude createEntityinclude() {
        Entityinclude i = new Entityinclude();
        this.entityincludes.add(i);
        return i;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setAutomaticgrouping(boolean b) {
        this.automaticGrouping = b;
    }

    public void setDistBase(String dbase) {
        this.dist_base = dbase;
    }

    public void setUseLicenseUrl(boolean useLicenseUrl) {
        this.useLicenseUrl = useLicenseUrl;
    }

    public Path createUpdaterJar() {
        this.updaterJar = new Path(this.getProject());
        return this.updaterJar;
    }

    private static String xmlEscape(String s) {
        int max = s.length();
        StringBuffer s2 = new StringBuffer((int)((double)max * 1.1 + 1.0));
        block6: for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    s2.append("&lt;");
                    continue block6;
                }
                case '>': {
                    s2.append("&gt;");
                    continue block6;
                }
                case '&': {
                    s2.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    s2.append("&quot;");
                    continue block6;
                }
                default: {
                    s2.append(c);
                }
            }
        }
        return s2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        Group root = new Group();
        for (FileSet fs : this.filesets) {
            root.addFileSet(fs);
        }
        this.groups.add(root);
        if (this.desc.exists()) {
            long time = this.desc.lastModified();
            boolean uptodate = true;
            block8: for (Group group : this.groups) {
                for (FileSet n : group.filesets) {
                    if (n == null) continue;
                    DirectoryScanner ds = n.getDirectoryScanner(this.getProject());
                    String[] files = ds.getIncludedFiles();
                    File bdir = ds.getBasedir();
                    for (String file : files) {
                        File n_file = new File(bdir, file);
                        if (n_file.lastModified() <= time) continue;
                        uptodate = false;
                        break block8;
                    }
                }
            }
            if (uptodate) {
                return;
            }
        }
        this.log("Creating update description " + this.desc.getAbsolutePath());
        Map<String, Collection<Module>> modulesByGroup = this.loadNBMs();
        boolean targetClustersDefined = false;
        for (Collection<Module> modules : modulesByGroup.values()) {
            for (Module m : modules) {
                targetClustersDefined |= m.xml.getAttributeNode("targetcluster") != null;
            }
        }
        boolean use25DTD = false;
        for (Collection collection : modulesByGroup.values()) {
            for (Module m : collection) {
                Element manifest = (Element)m.xml.getElementsByTagName("manifest").item(0);
                use25DTD |= m.autoload || m.eager || manifest.getAttribute("AutoUpdate-Show-In-Client").length() > 0 || manifest.getAttribute("AutoUpdate-Essential-Module").length() > 0;
            }
        }
        try {
            this.desc.delete();
            FileOutputStream os = new FileOutputStream(this.desc);
            try {
                void var6_19;
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                printWriter.println();
                SimpleDateFormat format = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy");
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                String date = format.format(new Date());
                if (this.entityincludes.size() > 0) {
                    int i;
                    String ent_name = this.desc.getAbsolutePath();
                    int xml_idx = ent_name.indexOf(".xml");
                    ent_name = xml_idx != -1 ? ent_name.substring(0, xml_idx) + ".ent" : ent_name + ".ent";
                    File desc_ent = new File(ent_name);
                    desc_ent.delete();
                    if (this.useLicenseUrl) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.6//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_6.dtd\" [");
                    } else if (use25DTD) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.5//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_5.dtd\" [");
                    } else if (targetClustersDefined) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.4//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_4.dtd\" [");
                    } else {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.3//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_3.dtd\" [");
                    }
                    printWriter.println("    <!ENTITY entity SYSTEM \"" + MakeUpdateDesc.xmlEscape(desc_ent.getName()) + "\">");
                    boolean inc_num = false;
                    for (i = 0; i < this.entityincludes.size(); ++i) {
                        Entityinclude ei = this.entityincludes.get(i);
                        printWriter.println("    <!ENTITY include" + i + " SYSTEM \"" + MakeUpdateDesc.xmlEscape(ei.file) + "\">");
                    }
                    printWriter.println("]>");
                    printWriter.println();
                    printWriter.println("<module_updates timestamp=\"" + MakeUpdateDesc.xmlEscape(date) + "\">");
                    printWriter.println("    &entity;");
                    for (i = 0; i < this.entityincludes.size(); ++i) {
                        printWriter.println("    &include" + i + ";");
                    }
                    printWriter.println("</module_updates>");
                    printWriter.println();
                    printWriter.flush();
                    printWriter.close();
                    os = new FileOutputStream(desc_ent);
                    PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                    printWriter2.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    printWriter2.println("<!-- external entity include " + date + " -->");
                    printWriter2.println();
                } else {
                    if (this.useLicenseUrl) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.6//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_6.dtd\">");
                    } else if (use25DTD) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.5//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_5.dtd\">");
                    } else if (targetClustersDefined) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.4//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_4.dtd\">");
                    } else {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.3//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_3.dtd\">");
                    }
                    printWriter.println("<module_updates timestamp=\"" + date + "\">");
                    printWriter.println();
                }
                var6_19.println();
                HashMap<String, Element> licenses = new HashMap<String, Element>();
                String prefix = null;
                if (this.dist_base != null) {
                    prefix = this.dist_base.equals(".") ? "" : this.dist_base + "/";
                }
                File licensesDir = new File(this.desc.getParentFile(), "licenses");
                if (this.useLicenseUrl) {
                    if (licensesDir.exists()) {
                        File[] licenseFiles;
                        for (File f : licenseFiles = licensesDir.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return pathname.getName().endsWith(".license");
                            }
                        })) {
                            f.delete();
                        }
                    } else {
                        licensesDir.mkdir();
                    }
                }
                for (Map.Entry<String, Collection<Module>> entry : modulesByGroup.entrySet()) {
                    String groupName = entry.getKey();
                    this.log("Creating group \"" + groupName + "\"");
                    if (groupName != null) {
                        var6_19.println("<module_group name=\"" + MakeUpdateDesc.xmlEscape(groupName) + "\">");
                        var6_19.println();
                    }
                    for (Module m : entry.getValue()) {
                        NodeList licenseList;
                        Element manifest;
                        String name;
                        Element module = m.xml;
                        if (module.getAttribute("downloadsize").equals("0")) {
                            module.setAttribute("downloadsize", Long.toString(m.nbm.length()));
                        }
                        if ((name = (manifest = (Element)module.getElementsByTagName("manifest").item(0)).getAttribute("OpenIDE-Module-Name")).length() > 0) {
                            this.log(" Adding module " + name + " (" + m.nbm.getAbsolutePath() + ")");
                        }
                        if (prefix != null) {
                            module.setAttribute("distribution", prefix + m.relativePath);
                        }
                        if ((licenseList = module.getElementsByTagName("license")).getLength() > 0) {
                            Element license = (Element)licenseList.item(0);
                            if (this.useLicenseUrl) {
                                String relativePath;
                                String path = relativePath = "licenses/" + license.getAttribute("name") + ".license";
                                if (prefix != null) {
                                    path = prefix + relativePath;
                                }
                                license.setAttribute("url", path);
                                String licenseText = license.getTextContent();
                                license.setTextContent("");
                                FileOutputStream fos = new FileOutputStream(new File(this.desc.getParentFile(), relativePath));
                                fos.write(licenseText.getBytes("UTF-8"));
                                fos.close();
                            }
                            licenses.put(license.getAttribute("name"), license);
                            module.removeChild(license);
                        }
                        if (m.autoload) {
                            module.setAttribute("autoload", "true");
                        }
                        if (m.eager) {
                            module.setAttribute("eager", "true");
                        }
                        var6_19.flush();
                        XMLUtil.write(module, (OutputStream)os);
                        var6_19.println();
                    }
                    if (groupName == null) continue;
                    var6_19.println("</module_group>");
                    var6_19.println();
                }
                var6_19.flush();
                for (Element license : licenses.values()) {
                    XMLUtil.write(license, (OutputStream)os);
                }
                if (this.entityincludes.size() <= 0) {
                    var6_19.println("</module_updates>");
                    var6_19.println();
                }
                var6_19.flush();
                var6_19.close();
            }
            finally {
                os.flush();
                ((OutputStream)os).close();
            }
        }
        catch (IOException ioe) {
            this.desc.delete();
            throw new BuildException("Cannot create update description", (Throwable)ioe, this.getLocation());
        }
        if (this.updaterJar != null && this.updaterJar.size() > 0) {
            try {
                MakeNBM.validateAgainstAUDTDs(new InputSource(this.desc.toURI().toString()), this.updaterJar, (Task)this);
            }
            catch (Exception x) {
                this.desc.delete();
                throw new BuildException("Could not validate " + this.desc + " after writing: " + x, (Throwable)x, this.getLocation());
            }
        } else {
            this.log("No updater.jar specified, cannot validate " + this.desc + " against DTD", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<Module>> loadNBMs() throws BuildException {
        final Collator COLL = Collator.getInstance();
        Comparator<String> groupNameComparator = new Comparator<String>(){

            @Override
            public int compare(String gn1, String gn2) {
                return gn1 != null ? (gn2 != null ? COLL.compare(gn1, gn2) : 1) : (gn2 != null ? -1 : 0);
            }
        };
        TreeMap<String, Collection<Module>> r = this.automaticGrouping ? new TreeMap(groupNameComparator) : new LinkedHashMap();
        Comparator<Module> moduleDisplayNameComparator = new Comparator<Module>(){

            @Override
            public int compare(Module m1, Module m2) {
                int res = COLL.compare(this.getName(m1), this.getName(m2));
                return res != 0 ? res : System.identityHashCode(m1) - System.identityHashCode(m2);
            }

            String getName(Module m) {
                Element mani = (Element)m.xml.getElementsByTagName("manifest").item(0);
                String displayName = mani.getAttribute("OpenIDE-Module-Name");
                if (displayName.length() > 0) {
                    return displayName;
                }
                return mani.getAttribute("OpenIDE-Module");
            }
        };
        for (Group g : this.groups) {
            TreeSet<Module> modules = (TreeSet<Module>)r.get(g.name);
            if (modules == null) {
                modules = new TreeSet<Module>(moduleDisplayNameComparator);
                r.put(g.name, modules);
            }
            for (FileSet fs : g.filesets) {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String file : ds.getIncludedFiles()) {
                    File n_file = new File(fs.getDir(this.getProject()), file);
                    try {
                        ZipFile zip = new ZipFile(n_file);
                        try {
                            String categ;
                            ZipEntry entry = zip.getEntry("Info/info.xml");
                            if (entry == null) {
                                throw new BuildException("NBM " + n_file + " was malformed: no Info/info.xml", this.getLocation());
                            }
                            EntityResolver nullResolver = new EntityResolver(){

                                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                                }
                            };
                            Module m = new Module();
                            InputStream is = zip.getInputStream(entry);
                            try {
                                m.xml = XMLUtil.parse(new InputSource(is), false, false, null, nullResolver).getDocumentElement();
                            }
                            finally {
                                is.close();
                            }
                            m.nbm = n_file;
                            m.relativePath = file.replace(File.separatorChar, '/');
                            Collection<Module> moduleCollection = modules;
                            Element manifest = (Element)m.xml.getElementsByTagName("manifest").item(0);
                            if (this.automaticGrouping && g.name == null && (categ = manifest.getAttribute("OpenIDE-Module-Display-Category")).length() > 0 && (moduleCollection = (Collection)r.get(categ)) == null) {
                                moduleCollection = new TreeSet<Module>(moduleDisplayNameComparator);
                                r.put(categ, moduleCollection);
                            }
                            boolean old = false;
                            String destDir = this.getProject().getProperty("netbeans.dest.dir");
                            if (destDir != null) {
                                for (File cluster : this.getProject().resolveFile(destDir).listFiles()) {
                                    if (!new File(cluster, "modules/org-netbeans-modules-autoupdate.jar").isFile()) continue;
                                    old = true;
                                    break;
                                }
                            }
                            if (!old) {
                                String cnb = manifest.getAttribute("OpenIDE-Module").replaceFirst("/\\d+$", "");
                                entry = zip.getEntry("netbeans/config/Modules/" + cnb.replace('.', '-') + ".xml");
                                if (entry != null) {
                                    is = zip.getInputStream(entry);
                                    try {
                                        NodeList nl = XMLUtil.parse(new InputSource(is), false, false, null, nullResolver).getElementsByTagName("param");
                                        for (int i = 0; i < nl.getLength(); ++i) {
                                            String name = ((Element)nl.item(i)).getAttribute("name");
                                            String value = ((Text)nl.item(i).getFirstChild()).getData();
                                            if (name.equals("autoload") && value.equals("true")) {
                                                m.autoload = true;
                                            }
                                            if (!name.equals("eager") || !value.equals("true")) continue;
                                            m.eager = true;
                                        }
                                    }
                                    finally {
                                        is.close();
                                    }
                                }
                            }
                            moduleCollection.add(m);
                        }
                        finally {
                            zip.close();
                        }
                    }
                    catch (Exception e) {
                        throw new BuildException("Cannot access nbm file: " + n_file, (Throwable)e, this.getLocation());
                    }
                }
            }
        }
        return r;
    }

    private static class Module {
        public Element xml;
        public File nbm;
        public String relativePath;
        public boolean autoload;
        public boolean eager;
    }

    public class Entityinclude {
        public String file;

        public void setFile(String f) {
            this.file = f;
        }
    }

    public class Group {
        public List<FileSet> filesets = new ArrayList<FileSet>();
        public String name;

        public void setName(String s) {
            this.name = s;
        }

        public void addFileSet(FileSet set) {
            this.filesets.add(set);
        }
    }
}

