/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.IntArrayBasedKeyTable;
import org.neo4j.collection.primitive.hopscotch.Table;

public class LongKeyIntValueTable
extends IntArrayBasedKeyTable<int[]> {
    public static final int NULL = -1;

    public LongKeyIntValueTable(int capacity) {
        super(capacity, 4, 32, new int[]{-1});
    }

    @Override
    public long key(int index) {
        return this.getLong(this.address(index));
    }

    @Override
    protected void internalPut(int actualIndex, long key, int[] value) {
        this.putLong(actualIndex, key);
        this.table[actualIndex + 2] = value[0];
    }

    @Override
    public int[] putValue(int index, int[] value) {
        int actualIndex = this.address(index) + 2;
        int previous = this.table[actualIndex];
        this.table[actualIndex] = value[0];
        return this.pack(previous);
    }

    @Override
    public int[] value(int index) {
        return this.pack(this.table[this.address(index) + 2]);
    }

    @Override
    protected Table<int[]> newInstance(int newCapacity) {
        return new LongKeyIntValueTable(newCapacity);
    }

    private int[] pack(int value) {
        ((int[])this.singleValue)[0] = value;
        return (int[])this.singleValue;
    }
}

