/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.IOUtils;

public class ServletRequestToOutputHandler
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public ServletRequestToOutputHandler() {
        this.registerSourceType(HttpServletRequest.class);
        this.setReturnClass(OutputHandler.class);
    }

    public Object doTransform(final Object src, String encoding) throws TransformerException {
        return new OutputHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(MuleEvent event, OutputStream out) throws IOException {
                ServletInputStream is = ((HttpServletRequest)src).getInputStream();
                try {
                    IOUtils.copyLarge((InputStream)is, (OutputStream)out);
                }
                finally {
                    is.close();
                }
            }
        };
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.priorityWeighting = weighting;
    }
}

