/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class HttpRequestBodyToParamMap
extends AbstractMessageAwareTransformer {
    public HttpRequestBodyToParamMap() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
    }

    public Object transform(MuleMessage message, String encoding) throws TransformerException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            String httpMethod = (String)message.getProperty("http.method");
            String contentType = (String)message.getProperty("Content-Type");
            if (!("GET".equalsIgnoreCase(httpMethod) || "POST".equalsIgnoreCase(httpMethod) && "application/x-www-form-urlencoded".equalsIgnoreCase(contentType))) {
                throw new Exception("The HTTP method or content type is unsupported!");
            }
            String queryString = null;
            if ("GET".equalsIgnoreCase(httpMethod)) {
                URI uri = new URI(message.getPayloadAsString(encoding));
                queryString = uri.getQuery();
            } else if ("POST".equalsIgnoreCase(httpMethod)) {
                queryString = new String(message.getPayloadAsBytes());
            }
            if (queryString != null && queryString.length() > 0) {
                String[] pairs = queryString.split("&");
                for (int x = 0; x < pairs.length; ++x) {
                    String[] nameValue = pairs[x].split("=");
                    if (nameValue.length != 2) continue;
                    paramMap.put(URLDecoder.decode(nameValue[0], encoding), URLDecoder.decode(nameValue[1], encoding));
                }
            }
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return paramMap;
    }

    public boolean isAcceptNull() {
        return false;
    }
}

