/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.transport.SessionHandler;

public class HttpSessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        Cookie[] cookies = (Cookie[])message.getProperty("cookies");
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                session.setProperty((Object)cookie.getName(), (Object)cookie.getValue());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added cookie to session: " + cookie.toString()));
            }
        }
    }

    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Iterator iterator = session.getPropertyNames();
        while (iterator.hasNext()) {
            Object name = iterator.next();
            Object value = session.getProperty(name);
            cookies.add(new Cookie(null, name.toString(), value.toString()));
        }
        if (cookies.size() > 0) {
            message.setProperty("cookies", (Object)cookies.toArray(new Cookie[cookies.size()]));
        }
    }

    public String getSessionIDKey() {
        return "ID";
    }
}

