/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Port;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.mule.transport.cxf.CxfConnector;
import org.mule.transport.cxf.transport.MuleUniversalConduit;
import org.mule.transport.cxf.transport.MuleUniversalDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleUniversalTransport
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory,
WSDLEndpointFactory {
    public static final String TRANSPORT_ID = "http://mule.codehaus.org/cxf";
    private static Set<String> PREFIXES = new HashSet<String>();
    private Map<String, Destination> destinations = new HashMap<String, Destination>();
    private Bus bus;
    private CxfConnector connector;

    public MuleUniversalTransport(CxfConnector connector) {
        ArrayList<String> tids = new ArrayList<String>();
        tids.add("http://schemas.xmlsoap.org/soap/http");
        this.setTransportIds(tids);
        this.connector = connector;
    }

    public Destination getDestination(EndpointInfo ei) throws IOException {
        return this.getDestination(ei, this.createReference(ei));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination getDestination(EndpointInfo ei, EndpointReferenceType reference) throws IOException {
        String uri = reference.getAddress().getValue();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        MuleUniversalTransport muleUniversalTransport = this;
        synchronized (muleUniversalTransport) {
            Destination d = this.destinations.get(uri);
            if (d == null) {
                d = this.createDestination(ei, reference);
                this.destinations.put(uri, d);
            }
            return d;
        }
    }

    private Destination createDestination(EndpointInfo ei, EndpointReferenceType reference) {
        return new MuleUniversalDestination(this, reference, ei);
    }

    public Conduit getConduit(EndpointInfo ei) throws IOException {
        return new MuleUniversalConduit(this, this.connector, ei, null);
    }

    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target) throws IOException {
        return new MuleUniversalConduit(this, this.connector, ei, target);
    }

    EndpointReferenceType createReference(EndpointInfo ei) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(ei.getAddress());
        epr.setAddress(address);
        return epr;
    }

    public Set<String> getUriPrefixes() {
        return PREFIXES;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    void remove(MuleUniversalDestination destination) {
        this.destinations.remove(destination.getAddress().getAddress().getValue());
    }

    public CxfConnector getConnector() {
        return this.connector;
    }

    public void createPortExtensors(EndpointInfo ei, Service service) {
    }

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        if (port != null) {
            List ees = port.getExtensibilityElements();
            for (Object extensor : ees) {
                if (extensor instanceof HTTPAddress) {
                    HTTPAddress httpAdd = (HTTPAddress)extensor;
                    HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                    info.setAddress(httpAdd.getLocationURI());
                    info.addExtensor(httpAdd);
                    return info;
                }
                if (!(extensor instanceof AddressType)) continue;
                AddressType httpAdd = (AddressType)extensor;
                HttpEndpointInfo info = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                info.setAddress(httpAdd.getLocation());
                info.addExtensor(httpAdd);
                return info;
            }
        }
        HttpEndpointInfo hei = new HttpEndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
        HttpAddressType at = new HttpAddressType();
        hei.addExtensor((Object)at);
        return hei;
    }

    static {
        PREFIXES.add("http://");
        PREFIXES.add("https://");
        PREFIXES.add("jms://");
        PREFIXES.add("vm://");
        PREFIXES.add("xmpp://");
        PREFIXES.add("smtp://");
        PREFIXES.add("tcp://");
    }

    private static class HttpAddressType
    extends AddressType
    implements HTTPAddress,
    SOAPAddress {
        public HttpAddressType() {
            this.setElementType(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
        }

        public String getLocationURI() {
            return this.getLocation();
        }

        public void setLocationURI(String locationURI) {
            this.setLocation(locationURI);
        }
    }

    private static class HttpEndpointInfo
    extends EndpointInfo {
        AddressType saddress;

        HttpEndpointInfo(ServiceInfo serv, String trans) {
            super(serv, trans);
        }

        public void setAddress(String s) {
            super.setAddress(s);
            if (this.saddress != null) {
                this.saddress.setLocation(s);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof AddressType) {
                this.saddress = (AddressType)el;
            }
        }
    }
}

