/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.mule.transport.cxf.support.ProxyService;

public class ProxyServiceFactoryBean
extends ReflectionServiceFactoryBean {
    private static final Logger LOG = LogUtils.getLogger(ProxyServiceFactoryBean.class);

    protected void initializeWSDLOperations() {
        if (this.getServiceClass().isAssignableFrom(ProxyService.class)) {
            this.initializeWSDLOperationsForProvider();
        } else {
            super.initializeWSDLOperations();
        }
    }

    protected void initializeWSDLOperationsForProvider() {
        Class<Source> c = Source.class;
        if (this.getEndpointInfo() == null && this.isFromWsdl()) {
            ArrayList<QName> enames = new ArrayList<QName>();
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (EndpointInfo ep : si.getEndpoints()) {
                    enames.add(ep.getName());
                }
            }
            LOG.log(Level.WARNING, "COULD_NOT_FIND_ENDPOINT", new Object[]{this.getEndpointName(), enames});
        }
        try {
            Method invoke = this.getServiceClass().getMethod("invoke", c);
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (OperationInfo o : si.getInterface().getOperations()) {
                    this.getMethodDispatcher().bind(o, new Method[]{invoke});
                }
            }
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
    }
}

