/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf.support;

import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.api.transport.MessageAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleProtocolHeadersOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public MuleProtocolHeadersOutInterceptor() {
        super("pre-stream");
        this.getAfter().add(AttachmentOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        MessageAdapter muleMsg = (MessageAdapter)message.getExchange().get((Object)"mule.message");
        if (muleMsg == null) {
            return;
        }
        this.extractAndSet(message, muleMsg, "Content-Type", "Content-Type");
        String method = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        if (method == null) {
            method = "POST";
        }
        muleMsg.setProperty("http.method", (Object)method);
        Map reqHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (reqHeaders != null) {
            for (Map.Entry e : reqHeaders.entrySet()) {
                String key = (String)e.getKey();
                String val = this.format((List)e.getValue());
                muleMsg.setProperty(key, (Object)val);
            }
        }
        if (!Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"))) {
            message.getInterceptorChain().pause();
        }
    }

    private void extractAndSet(Message message, MessageAdapter muleMsg, String cxfHeader, String muleHeader) {
        String ct = (String)message.get((Object)cxfHeader);
        if (ct != null) {
            muleMsg.setProperty(muleHeader, (Object)ct);
        }
    }

    private String format(List<String> value) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : value) {
            if (!first) {
                sb.append(", ");
                first = false;
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

