/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.ServiceException;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.NullPayload;
import org.mule.transport.cxf.CxfMessageAdapter;
import org.mule.transport.cxf.CxfMessageReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleInvoker
implements Invoker {
    private final CxfMessageReceiver receiver;
    private final boolean synchronous;
    private Class<?> targetClass;

    public MuleInvoker(CxfMessageReceiver receiver, Class<?> targetClass, boolean synchronous) {
        this.receiver = receiver;
        this.targetClass = targetClass;
        this.synchronous = synchronous;
    }

    public Object invoke(Exchange exchange, Object o) {
        MuleMessage message = null;
        try {
            String corSeq;
            String corGroupSize;
            String corId;
            String replyTo;
            MuleMessage reqMsg = (MuleMessage)exchange.getInMessage().get((Object)"mule.message");
            CxfMessageAdapter messageAdapter = (CxfMessageAdapter)this.receiver.getConnector().getMessageAdapter((Object)reqMsg);
            messageAdapter.setPayload(exchange.getInMessage());
            BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            Service svc = (Service)exchange.get(Service.class);
            if (!this.receiver.isProxy()) {
                MethodDispatcher md = (MethodDispatcher)svc.get((Object)MethodDispatcher.class.getName());
                Method m = md.getMethod(bop);
                if (this.targetClass != null) {
                    m = MuleInvoker.matchMethod(m, this.targetClass);
                }
                messageAdapter.setProperty("method", m);
            }
            DefaultMuleMessage muleReq = new DefaultMuleMessage((Object)messageAdapter);
            if (bop != null) {
                muleReq.setProperty("cxf_operation", (Object)bop.getOperationInfo().getName(), PropertyScope.INVOCATION);
                muleReq.setProperty("cxf_service", (Object)svc.getName(), PropertyScope.INVOCATION);
            }
            if ((replyTo = (String)exchange.getInMessage().get((Object)"MULE_REPLYTO")) != null) {
                muleReq.setReplyTo((Object)replyTo);
            }
            if ((corId = (String)exchange.getInMessage().get((Object)"MULE_CORRELATION_ID")) != null) {
                muleReq.setCorrelationId(corId);
            }
            if ((corGroupSize = (String)exchange.getInMessage().get((Object)"MULE_CORRELATION_GROUP_SIZE")) != null) {
                muleReq.setCorrelationGroupSize(Integer.valueOf(corGroupSize).intValue());
            }
            if ((corSeq = (String)exchange.getInMessage().get((Object)"MULE_CORRELATION_SEQUENCE")) != null) {
                muleReq.setCorrelationSequence(Integer.valueOf(corSeq).intValue());
            }
            message = this.receiver.routeMessage((MuleMessage)muleReq, this.synchronous);
        }
        catch (MuleException e) {
            throw new Fault((Throwable)e);
        }
        if (message != null) {
            if (message.getExceptionPayload() != null) {
                Throwable cause = message.getExceptionPayload().getException();
                if (cause instanceof ServiceException) {
                    cause = cause.getCause();
                }
                exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                if (cause instanceof Fault) {
                    throw (Fault)cause;
                }
                throw new Fault(cause);
            }
            if (message.getPayload() instanceof NullPayload) {
                return new MessageContentsList(new Object[]{null});
            }
            if (this.receiver.isProxy()) {
                message.getPayload();
                return new Object[]{message};
            }
            return new Object[]{message.getPayload()};
        }
        return new MessageContentsList(new Object[]{null});
    }

    public InboundEndpoint getEndpoint() {
        return this.receiver.getEndpoint();
    }

    private static Method matchMethod(Method methodToMatch, Class<?> targetClass) {
        Class<?>[] interfaces = targetClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method m = MuleInvoker.getMostSpecificMethod(methodToMatch, interfaces[i]);
            if (methodToMatch.equals(m)) continue;
            return m;
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

