/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.NotPermittedException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.spring.security.SpringAuthenticationAdapter;
import org.mule.module.spring.security.i18n.SpringSecurityMessages;
import org.mule.security.AbstractSecurityFilter;

public class AuthorizationFilter
extends AbstractSecurityFilter {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Collection<String> requiredAuthorities = new HashSet<String>();

    public void doFilter(MuleEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        Authentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (auth == null) {
            throw new UnauthorisedException(CoreMessages.authNoCredentials());
        }
        if (!(auth instanceof SpringAuthenticationAdapter)) {
            throw new UnauthorisedException(SpringSecurityMessages.springAuthenticationRequired());
        }
        SpringAuthenticationAdapter springAuth = (SpringAuthenticationAdapter)auth;
        String principalName = springAuth.getName();
        Object[] authorities = springAuth.getAuthorities();
        boolean authorized = false;
        if (authorities != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found authorities '" + Arrays.toString(authorities) + "' for principal '" + principalName + "'."));
            }
            for (Object authority : authorities) {
                if (!this.requiredAuthorities.contains(authority.getAuthority())) continue;
                authorized = true;
            }
        }
        if (!authorized) {
            this.logger.info((Object)MessageFormat.format("Could not find required authorities for {0}. Required authorities: {1}. Authorities found: {2}.", principalName, Arrays.toString(this.requiredAuthorities.toArray()), Arrays.toString(authorities)));
            throw new NotPermittedException(SpringSecurityMessages.noGrantedAuthority(principalName));
        }
    }

    public Collection<String> getRequiredAuthorities() {
        return this.requiredAuthorities;
    }

    public void setRequiredAuthorities(Collection<String> requiredAuthorities) {
        this.requiredAuthorities = requiredAuthorities;
    }
}

