/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.mule.api.AnnotatedObject;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AbstractSelectiveRouter;
import org.mule.routing.MessageProcessorFilterPair;
import org.springframework.beans.factory.FactoryBean;

public abstract class AbstractSelectiveRouterFactoryBean
implements FactoryBean,
AnnotatedObject {
    private MessageProcessor defaultProcessor;
    private Collection<MessageProcessorFilterPair> conditionalMessageProcessors;
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    public void setDefaultRoute(MessageProcessorFilterPair conditionalProcessor) {
        this.defaultProcessor = conditionalProcessor.getMessageProcessor();
    }

    public void setRoutes(Collection<MessageProcessorFilterPair> conditionalMessageProcessors) {
        this.conditionalMessageProcessors = conditionalMessageProcessors;
    }

    public Object getObject() throws Exception {
        AbstractSelectiveRouter router = this.newAbstractSelectiveRouter();
        router.setAnnotations(this.getAnnotations());
        router.setDefaultRoute(this.defaultProcessor);
        for (MessageProcessorFilterPair mpfp : this.conditionalMessageProcessors) {
            router.addRoute(mpfp.getMessageProcessor(), mpfp.getFilter());
        }
        return router;
    }

    protected abstract AbstractSelectiveRouter newAbstractSelectiveRouter();

    public boolean isSingleton() {
        return true;
    }

    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

