/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mortbay.jetty.plugin.AbstractJetty6Mojo;
import org.mortbay.jetty.plugin.util.Scanner;

public class Jetty6RunWar
extends AbstractJetty6Mojo {
    private File webApp;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.getWebApplication().setWebAppSrcDir(this.webApp);
    }

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void configureScanner() throws MojoExecutionException {
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getFile());
        scanList.add(this.webApp);
        this.setScanList(scanList);
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new Scanner.Listener(){

            public void changesDetected(Scanner scanner, List changes) {
                try {
                    Jetty6RunWar.this.getLog().info((CharSequence)"Restarting webapp ...");
                    Jetty6RunWar.this.getLog().debug((CharSequence)"Stopping webapp ...");
                    Jetty6RunWar.this.getWebApplication().stop();
                    Jetty6RunWar.this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
                    Jetty6RunWar.this.checkPomConfiguration();
                    if (changes.contains(Jetty6RunWar.this.getProject().getFile().getCanonicalPath())) {
                        Jetty6RunWar.this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                        ArrayList scanList = Jetty6RunWar.this.getScanList();
                        scanList.clear();
                        scanList.add(Jetty6RunWar.this.getProject().getFile());
                        scanList.add(Jetty6RunWar.this.webApp);
                        Jetty6RunWar.this.setScanList(scanList);
                        scanner.setRoots(scanList);
                    }
                    Jetty6RunWar.this.getLog().debug((CharSequence)"Restarting webapp ...");
                    Jetty6RunWar.this.getWebApplication().start();
                    Jetty6RunWar.this.getLog().info((CharSequence)"Restart completed.");
                }
                catch (Exception e) {
                    Jetty6RunWar.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void finishConfigurationBeforeStart() {
    }
}

