/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.openshift;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.social.openshift.OpenshiftV4IdentityProvider;
import org.keycloak.social.openshift.OpenshiftV4IdentityProviderConfig;

public class OpenshiftV4IdentityProviderTest {
    private final String TEST_OAUTH_METADATA_FILE = "/org/keycloak/test/social/openshift/OpenshiftV4-oauth-metadata.json";
    private URL oauthMetadataFile;
    private String authMetadata;
    private Map<String, String> oauthMetadataMap;

    @Before
    public void before() throws Exception {
        this.oauthMetadataFile = OpenshiftV4IdentityProviderTest.class.getResource("/org/keycloak/test/social/openshift/OpenshiftV4-oauth-metadata.json");
        this.authMetadata = IOUtils.toString((URL)this.oauthMetadataFile, (Charset)StandardCharsets.UTF_8);
        ObjectMapper objectMapper = new ObjectMapper();
        this.oauthMetadataMap = (Map)objectMapper.readValue(this.authMetadata, HashMap.class);
    }

    @Test
    public void testExtractingConfigProperties() {
        OpenshiftV4IdentityProviderConfig config = new OpenshiftV4IdentityProviderConfig(new IdentityProviderModel());
        new OpenshiftV4IdentityProvider(null, config){

            InputStream getOauthMetadataInputStream(KeycloakSession session, String baseUrl) {
                return new ByteArrayInputStream(OpenshiftV4IdentityProviderTest.this.authMetadata.getBytes());
            }
        };
        Assert.assertEquals((Object)"https://api.preview.openshift.com/apis/user.openshift.io/v1/users/~", (Object)config.getUserInfoUrl());
        Assert.assertEquals((Object)this.oauthMetadataMap.get("token_endpoint"), (Object)config.getTokenUrl());
        Assert.assertEquals((Object)this.oauthMetadataMap.get("authorization_endpoint"), (Object)config.getAuthorizationUrl());
    }

    @Test
    public void testHttpClientErrors() {
        OpenshiftV4IdentityProviderConfig config = new OpenshiftV4IdentityProviderConfig(new IdentityProviderModel());
        try {
            new OpenshiftV4IdentityProvider(null, config){

                InputStream getOauthMetadataInputStream(KeycloakSession session, String baseUrl) {
                    throw new RuntimeException("Failed : HTTP error code : 500");
                }
            };
            Assert.fail();
        }
        catch (IdentityBrokerException identityBrokerException) {
            // empty catch block
        }
    }
}

