/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.github;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.social.github.GitHubIdentityProvider;

public class GitHubIdentityProviderTest {
    @Test
    public void testGitHubIdentityProvider() {
        OAuth2IdentityProviderConfig config = new OAuth2IdentityProviderConfig();
        GitHubIdentityProvider idp = new GitHubIdentityProvider(null, config);
        this.validateUrls(idp, "https://github.com", "https://api.github.com");
    }

    @Test
    public void testGitHubIdentityProviderOverrides() {
        OAuth2IdentityProviderConfig config = new OAuth2IdentityProviderConfig();
        String baseUrl = "https://test.com";
        String apiUrl = "https://api.test.com";
        config.getConfig().put("baseUrl", baseUrl);
        config.getConfig().put("apiUrl", apiUrl);
        GitHubIdentityProvider idp = new GitHubIdentityProvider(null, config);
        this.validateUrls(idp, baseUrl, apiUrl);
    }

    protected void validateUrls(GitHubIdentityProvider idp, String baseUrl, String apiUrl) {
        OAuth2IdentityProviderConfig config = idp.getConfig();
        Assert.assertEquals((Object)(baseUrl + "/login/oauth/authorize"), (Object)config.getAuthorizationUrl());
        Assert.assertEquals((Object)(baseUrl + "/login/oauth/access_token"), (Object)config.getTokenUrl());
        Assert.assertEquals((Object)(apiUrl + "/user/emails"), config.getConfig().get("emailUrl"));
        Assert.assertEquals((Object)(apiUrl + "/user"), (Object)config.getUserInfoUrl());
        Assert.assertEquals((Object)(apiUrl + "/user"), (Object)idp.getProfileEndpointForValidation(null));
    }
}

