/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.util.JsonSerialization;

public class VerifiableCredentialTest {
    @Test
    public void testIssuerIsDeserializedAsUri() throws IOException {
        String verifiableCredentialJson = "{\n  \"@context\": [\n    \"https://www.w3.org/ns/credentials/v2\",\n    \"https://www.w3.org/ns/credentials/examples/v2\"\n  ],\n  \"id\": \"http://university.example/credentials/3732\",\n  \"type\": [\"VerifiableCredential\", \"ExampleDegreeCredential\"],\n  \"issuer\": \"https://university.example/issuers/565049\",\n  \"validFrom\": \"2010-01-01T00:00:00Z\",\n  \"credentialSubject\": {\n    \"id\": \"did:example:ebfeb1f712ebc6f1c276e12ec21\",\n    \"degree\": {\n      \"type\": \"ExampleBachelorDegree\",\n      \"name\": \"Bachelor of Science and Arts\"\n    }\n  }\n}\n";
        VerifiableCredential verifiableCredential = (VerifiableCredential)JsonSerialization.readValue((String)"{\n  \"@context\": [\n    \"https://www.w3.org/ns/credentials/v2\",\n    \"https://www.w3.org/ns/credentials/examples/v2\"\n  ],\n  \"id\": \"http://university.example/credentials/3732\",\n  \"type\": [\"VerifiableCredential\", \"ExampleDegreeCredential\"],\n  \"issuer\": \"https://university.example/issuers/565049\",\n  \"validFrom\": \"2010-01-01T00:00:00Z\",\n  \"credentialSubject\": {\n    \"id\": \"did:example:ebfeb1f712ebc6f1c276e12ec21\",\n    \"degree\": {\n      \"type\": \"ExampleBachelorDegree\",\n      \"name\": \"Bachelor of Science and Arts\"\n    }\n  }\n}\n", VerifiableCredential.class);
        Assert.assertEquals(URI.class, verifiableCredential.getIssuer().getClass());
    }

    @Test
    public void testDeserializeIssuerAsMap() throws IOException {
        String verifiableCredentialJson = "{\n  \"@context\": [\n    \"https://www.w3.org/ns/credentials/v2\",\n    \"https://www.w3.org/ns/credentials/examples/v2\"\n  ],\n  \"id\": \"http://university.example/credentials/3732\",\n  \"type\": [\"VerifiableCredential\", \"ExampleDegreeCredential\"],\n  \"issuer\": {\n    \"id\": \"https://university.example/issuers/565049\",\n    \"name\": \"Example University\",\n    \"description\": \"A public university focusing on teaching examples.\"\n  },\n  \"validFrom\": \"2015-05-10T12:30:00Z\",\n  \"name\": \"Example University Degree\",\n  \"description\": \"2015 Bachelor of Science and Arts Degree\",\n  \"credentialSubject\": {\n    \"id\": \"did:example:ebfeb1f712ebc6f1c276e12ec21\",\n    \"degree\": {\n      \"type\": \"ExampleBachelorDegree\",\n      \"name\": \"Bachelor of Science and Arts\"\n    }\n  }\n}\n";
        VerifiableCredential verifiableCredential = (VerifiableCredential)JsonSerialization.readValue((String)"{\n  \"@context\": [\n    \"https://www.w3.org/ns/credentials/v2\",\n    \"https://www.w3.org/ns/credentials/examples/v2\"\n  ],\n  \"id\": \"http://university.example/credentials/3732\",\n  \"type\": [\"VerifiableCredential\", \"ExampleDegreeCredential\"],\n  \"issuer\": {\n    \"id\": \"https://university.example/issuers/565049\",\n    \"name\": \"Example University\",\n    \"description\": \"A public university focusing on teaching examples.\"\n  },\n  \"validFrom\": \"2015-05-10T12:30:00Z\",\n  \"name\": \"Example University Degree\",\n  \"description\": \"2015 Bachelor of Science and Arts Degree\",\n  \"credentialSubject\": {\n    \"id\": \"did:example:ebfeb1f712ebc6f1c276e12ec21\",\n    \"degree\": {\n      \"type\": \"ExampleBachelorDegree\",\n      \"name\": \"Bachelor of Science and Arts\"\n    }\n  }\n}\n", VerifiableCredential.class);
        Assert.assertTrue((boolean)Map.class.isAssignableFrom(verifiableCredential.getIssuer().getClass()));
    }
}

