/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import jakarta.ws.rs.core.HttpHeaders;
import java.net.URI;
import java.util.Locale;
import org.keycloak.Token;
import org.keycloak.common.ClientConnection;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.Theme;
import org.keycloak.urls.UrlType;

public interface KeycloakContext {
    public URI getAuthServerUrl();

    public String getContextPath();

    public KeycloakUriInfo getUri();

    public KeycloakUriInfo getUri(UrlType var1);

    public HttpHeaders getRequestHeaders();

    @Deprecated(forRemoval=true)
    default public <T> T getContextObject(Class<T> clazz) {
        return null;
    }

    public RealmModel getRealm();

    public void setRealm(RealmModel var1);

    public ClientModel getClient();

    public void setClient(ClientModel var1);

    public OrganizationModel getOrganization();

    public void setOrganization(OrganizationModel var1);

    public ClientConnection getConnection();

    public Locale resolveLocale(UserModel var1);

    default public Locale resolveLocale(UserModel user, Theme.Type themeType) {
        return this.resolveLocale(user);
    }

    public AuthenticationSessionModel getAuthenticationSession();

    public void setAuthenticationSession(AuthenticationSessionModel var1);

    public HttpRequest getHttpRequest();

    public HttpResponse getHttpResponse();

    public void setConnection(ClientConnection var1);

    public void setHttpRequest(HttpRequest var1);

    public void setHttpResponse(HttpResponse var1);

    public UserSessionModel getUserSession();

    public void setUserSession(UserSessionModel var1);

    public Token getBearerToken();

    public void setBearerToken(Token var1);
}

