/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.keycloak.sdjwt.SdJwtUtils;

public class TestUtils {
    public static JsonNode readClaimSet(Class<?> klass, String path) {
        JsonNode jsonNode;
        block8: {
            InputStream is = klass.getClassLoader().getResourceAsStream(path);
            try {
                jsonNode = SdJwtUtils.mapper.readTree(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading file at path: " + path, e);
                }
            }
            is.close();
        }
        return jsonNode;
    }

    public static String readFileAsString(Class<?> klass, String filePath) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(klass.getClassLoader().getResourceAsStream(filePath)));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file at path: " + filePath, e);
        }
        return stringBuilder.toString();
    }

    public static String splitStringIntoLines(String input, int lineLength) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); i += lineLength) {
            int end = Math.min(input.length(), i + lineLength);
            result.append(input, i, end).append("\n");
        }
        return result.toString();
    }
}

