/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.reflection.input;

import com.google.common.base.Function;
import java.util.List;
import org.jtwig.reflection.util.Lists2;

public class InputParameterResolverContext<T> {
    private final List<InputParameter<T>> inputParameters;

    private InputParameterResolverContext(InputParameterResolverContext<T> prototype) {
        this.inputParameters = Lists2.transform(prototype.inputParameters, new Function<InputParameter<T>, InputParameter<T>>(){

            public InputParameter<T> apply(InputParameter<T> input) {
                InputParameter<Object> clone = new InputParameter<Object>(input.value);
                ((InputParameter)clone).used = input.used;
                return clone;
            }
        });
    }

    public InputParameterResolverContext(List<T> inputParameters) {
        this.inputParameters = Lists2.transform(inputParameters, new Function<T, InputParameter<T>>(){

            public InputParameter<T> apply(T input) {
                return new InputParameter(input);
            }
        });
    }

    public InputParameterResolverContext<T> markAsUsed(int position) {
        ((InputParameter)this.inputParameters.get(position)).used = true;
        return this;
    }

    public boolean isUsed(int position) {
        return ((InputParameter)this.inputParameters.get(position)).used;
    }

    public T value(int position) {
        return (T)((InputParameter)this.inputParameters.get(position)).value;
    }

    public int size() {
        return this.inputParameters.size();
    }

    public InputParameterResolverContext<T> clone() {
        return new InputParameterResolverContext<T>(this);
    }

    public void merge(InputParameterResolverContext<T> clonedContext) {
        for (int i = 0; i < clonedContext.inputParameters.size(); ++i) {
            ((InputParameter)this.inputParameters.get(i)).used = ((InputParameter)clonedContext.inputParameters.get(i)).used;
        }
    }

    public boolean fullyUsed() {
        for (InputParameter<T> inputParameter : this.inputParameters) {
            if (((InputParameter)inputParameter).used) continue;
            return false;
        }
        return true;
    }

    private static class InputParameter<T> {
        private final T value;
        private boolean used;

        public InputParameter(T value) {
            this.value = value;
        }
    }
}

