/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Objects;
import org.jruby.EvalType;
import org.jruby.RubyProc;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.func.FunctionOneOrTwoOrThree;

public class Block
implements FunctionOneOrTwoOrThree<ThreadContext, IRubyObject, IRubyObject, IRubyObject> {
    private RubyProc proc = null;
    public final Type type;
    private final Binding binding;
    private final BlockBody body;
    private boolean escaped;
    private final Block escapeBlock;
    private final EvalType evalType;
    public static final Block NULL_BLOCK = new Block(BlockBody.NULL_BODY, new Binding(null, new Frame(), Visibility.PUBLIC));

    private Block(BlockBody body, Binding binding2, Type type2, Block escapeBlock, EvalType evalType) {
        assert (binding2 != null);
        this.body = body;
        this.binding = binding2;
        this.type = type2;
        this.escapeBlock = escapeBlock;
        this.evalType = evalType;
    }

    public Block(BlockBody body, Binding binding2, Type type2) {
        assert (binding2 != null);
        this.body = body;
        this.binding = binding2;
        this.type = type2;
        this.escapeBlock = this;
        this.evalType = EvalType.NONE;
    }

    public Block(BlockBody body, Binding binding2) {
        this(body, binding2, Type.NORMAL);
    }

    public Block(BlockBody body) {
        this(body, NULL_BLOCK.getBinding(), Type.NORMAL);
    }

    public DynamicScope allocScope(DynamicScope parentScope) {
        DynamicScope newScope = DynamicScope.newDynamicScope(this.body.getStaticScope(), parentScope, this.evalType);
        if (this.type == Type.LAMBDA) {
            newScope.setLambda(true);
        }
        return newScope;
    }

    public EvalType getEvalType() {
        return this.evalType;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.body.call(context, this, args2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block blockArg) {
        return this.body.call(context, this, args2, blockArg);
    }

    public IRubyObject call(ThreadContext context) {
        return this.body.call(context, this);
    }

    public IRubyObject call(ThreadContext context, Block blockArg) {
        return this.body.call(context, this, blockArg);
    }

    public IRubyObject yieldSpecific(ThreadContext context) {
        return this.body.yieldSpecific(context, this);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0) {
        return this.body.call(context, this, arg0);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, Block blockArg) {
        return this.body.call(context, this, arg0, blockArg);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0) {
        return this.body.yieldSpecific(context, this, arg0);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.body.call(context, this, arg0, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block blockArg) {
        return this.body.call(context, this, arg0, arg1, blockArg);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.body.yieldSpecific(context, this, arg0, arg1);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.body.call(context, this, arg0, arg1, arg2);
    }

    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block blockArg) {
        return this.body.call(context, this, arg0, arg1, arg2, blockArg);
    }

    public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.body.yieldSpecific(context, this, arg0, arg1, arg2);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2) {
        return this.body.yield(context, this, value2);
    }

    @Override
    public IRubyObject apply(ThreadContext context) {
        return this.call(context);
    }

    @Override
    public IRubyObject apply(ThreadContext context, IRubyObject arg0) {
        return this.call(context, arg0);
    }

    @Override
    public IRubyObject apply(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, arg0, arg1);
    }

    private static IRubyObject[] maybeSpreadArgs(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.type != Type.LAMBDA && args2.length == 1 && block.getSignature().isSpreadable() ? IRRuntimeHelpers.toAry(context, args2) : args2;
    }

    public IRubyObject yieldNonArray(ThreadContext context, IRubyObject value2, IRubyObject self2) {
        IRubyObject[] args2 = Block.maybeSpreadArgs(context, new IRubyObject[]{value2}, this);
        return this.body.yield(context, this, args2, self2);
    }

    public IRubyObject yieldArray(ThreadContext context, IRubyObject value2, IRubyObject self2) {
        IRubyObject[] args2 = Block.maybeSpreadArgs(context, IRRuntimeHelpers.singleBlockArgToArray(value2), this);
        return this.body.yield(context, this, args2, self2);
    }

    public IRubyObject yieldValues(ThreadContext context, IRubyObject[] args2) {
        return this.body.yield(context, this, Block.maybeSpreadArgs(context, args2, this), null);
    }

    public Block cloneBlock() {
        return this.cloneBlockAsType(this.type);
    }

    public Block cloneBlockAsType(Type newType) {
        return new Block(this.body, this.binding, newType, this, this.evalType);
    }

    public Block cloneBlockAndBinding() {
        return this.cloneBlockAndBinding(this.evalType);
    }

    public Block cloneBlockAndBinding(EvalType evalType) {
        return new Block(this.body, this.binding.clone(), this.type, this, evalType);
    }

    public Block cloneBlockAndFrame() {
        return this.cloneBlockAndFrame(EvalType.NONE);
    }

    public Block cloneBlockAndFrame(EvalType evalType) {
        Binding oldBinding = this.binding;
        Binding binding2 = new Binding(oldBinding.getSelf(), oldBinding.getFrame().duplicate(), oldBinding.getVisibility(), oldBinding.getDynamicScope(), oldBinding.getMethod(), oldBinding.getFile(), oldBinding.getLine());
        return new Block(this.body, binding2, this.type, this, evalType);
    }

    public Block cloneBlockForEval(IRubyObject self2, EvalType evalType) {
        Block block = new Block(this.body, this.binding, this.type, this, evalType);
        block.getBinding().setSelf(self2);
        block.getBinding().getFrame().setSelf(self2);
        return block;
    }

    public Block deepCloneBlockForEval(IRubyObject self2, EvalType evalType) {
        Block block = this.cloneBlockAndBinding(evalType);
        block.getBinding().setSelf(self2);
        block.getBinding().getFrame().setSelf(self2);
        return block;
    }

    @Deprecated
    public Arity arity() {
        return this.getSignature().arity();
    }

    public Signature getSignature() {
        return this.body.getSignature();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public final boolean isGiven() {
        return this != NULL_BLOCK;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    public boolean isEscaped() {
        return this.escapeBlock.escaped;
    }

    public void escape() {
        this.escapeBlock.escaped = true;
    }

    public Visibility getVisibility() {
        return this.binding.getFrame().getVisibility();
    }

    public void setVisibility(Visibility vis) {
        this.binding.getFrame().setVisibility(vis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Block)) {
            return false;
        }
        Block that = (Block)other;
        return this.binding.equals(that.binding) && this.body == that.body;
    }

    public int hashCode() {
        int hash2 = 11;
        hash2 = 13 * hash2 + Objects.hashCode(this.binding);
        hash2 = 17 * hash2 + Objects.hashCode(this.body);
        return hash2;
    }

    static {
        NULL_BLOCK.getBinding().getFrame().updateFrame(null, null, "", NULL_BLOCK);
    }

    public static enum Type {
        NORMAL(false),
        PROC(false),
        LAMBDA(true),
        THREAD(false);

        public final boolean checkArity;

        private Type(boolean checkArity) {
            this.checkArity = checkArity;
        }
    }
}

