/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.keyStorage.InlinedKeyStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentEnumeratorBase<Data>
implements Forceable,
DataEnumeratorEx<Data>,
Closeable {
    protected static final Logger LOG = Logger.getInstance(PersistentEnumerator.class);
    private static final CacheKey ourFlyweight = new FlyweightKey();
    protected final ResizeableMappedFile myStorage;
    @NotNull
    private final AppendableObjectStorage<Data> myKeyStorage;
    final KeyDescriptor<Data> myDataDescriptor;
    protected final Path myFile;
    private final Version myVersion;
    private final boolean myDoCaching;
    private volatile boolean myDirtyStatusUpdateInProgress;
    private boolean myClosed;
    private boolean myDirty;
    private boolean myCorrupted;
    private RecordBufferHandler<PersistentEnumeratorBase<?>> myRecordHandler;
    private Flushable myMarkCleanCallback;
    private static final int ENUMERATION_CACHE_SIZE;
    private static final SLRUMap<Object, Integer> ourEnumerationCache;

    private static CacheKey sharedKey(Object key, PersistentEnumeratorBase owner) {
        PersistentEnumeratorBase.ourFlyweight.key = key;
        PersistentEnumeratorBase.ourFlyweight.owner = owner;
        return ourFlyweight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEnumeratorBase(@NotNull Path file2, @NotNull ResizeableMappedFile storage2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @NotNull Version version, @NotNull RecordBufferHandler<? extends PersistentEnumeratorBase<?>> recordBufferHandler, boolean doCaching) throws IOException {
        block25: {
            if (file2 == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(0);
            }
            if (storage2 == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(1);
            }
            if (dataDescriptor == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(2);
            }
            if (version == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(3);
            }
            if (recordBufferHandler == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(4);
            }
            this.myDataDescriptor = dataDescriptor;
            this.myFile = file2;
            this.myVersion = version;
            this.myRecordHandler = recordBufferHandler;
            this.myDoCaching = doCaching;
            if (!Files.exists(file2, new LinkOption[0])) {
                if (file2.getFileSystem().isReadOnly()) {
                    throw new IOException(file2 + " in " + file2.getFileSystem() + " is not exist");
                }
                FileUtil.delete(this.keyStreamFile());
                if (!FileUtil.createIfDoesntExist(file2.toFile())) {
                    throw new IOException("Cannot create empty file: " + file2);
                }
            }
            this.myStorage = storage2;
            this.lockStorageWrite();
            try {
                int sign;
                if (this.myStorage.length() == 0L) {
                    try {
                        this.markDirty(true);
                        this.putMetaData(0L);
                        this.putMetaData2(0L);
                        this.setupEmptyFile();
                        break block25;
                    }
                    catch (RuntimeException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw new CorruptedException(file2);
                    }
                }
                try {
                    sign = this.myStorage.getInt(0L);
                }
                catch (Exception e) {
                    LOG.info(e);
                    sign = this.myVersion.dirtyMagic;
                }
                if (sign != this.myVersion.correctlyClosedMagic) {
                    this.myStorage.close();
                    if (sign != this.myVersion.dirtyMagic) {
                        throw new VersionUpdatedException(file2);
                    }
                    throw new CorruptedException(file2);
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        if (dataDescriptor instanceof InlineKeyDescriptor) {
            this.myKeyStorage = new InlinedKeyStorage((InlineKeyDescriptor)dataDescriptor);
        } else {
            try {
                this.myKeyStorage = new AppendableStorageBackedByResizableMappedFile<Data>(this.keyStreamFile(), initialSize, this.myStorage.getPagedFileStorage().getStorageLockContext(), 0x100000, false, dataDescriptor);
            }
            catch (Throwable e) {
                LOG.info(e);
                this.myStorage.close();
                throw new CorruptedException(file2);
            }
        }
    }

    @NotNull
    protected Object getDataAccessLock() {
        PersistentEnumeratorBase persistentEnumeratorBase = this;
        if (persistentEnumeratorBase == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(5);
        }
        return persistentEnumeratorBase;
    }

    void lockStorageRead() {
        this.myStorage.getPagedFileStorage().lockRead();
    }

    void unlockStorageRead() {
        this.myStorage.getPagedFileStorage().unlockRead();
    }

    void lockStorageWrite() {
        this.myStorage.getPagedFileStorage().lockWrite();
    }

    void unlockStorageWrite() {
        this.myStorage.getPagedFileStorage().unlockWrite();
    }

    protected abstract void setupEmptyFile() throws IOException;

    @NotNull
    final RecordBufferHandler<PersistentEnumeratorBase<?>> getRecordHandler() {
        RecordBufferHandler<PersistentEnumeratorBase<?>> recordBufferHandler = this.myRecordHandler;
        if (recordBufferHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(6);
        }
        return recordBufferHandler;
    }

    public void setRecordHandler(@NotNull RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
        if (recordHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(7);
        }
        this.myRecordHandler = recordHandler;
    }

    void setMarkCleanCallback(Flushable markCleanCallback) {
        this.myMarkCleanCallback = markCleanCallback;
    }

    public Data getValue(int keyId, int processingKey) throws IOException {
        return this.valueOf(keyId);
    }

    public int tryEnumerate(Data value2) throws IOException {
        return this.doEnumerate(value2, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnumerate(Data value2, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        int id;
        if (this.myDoCaching && !saveNewValue) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                Integer cachedId = ourEnumerationCache.get(PersistentEnumeratorBase.sharedKey(value2, this));
                if (cachedId != null) {
                    return cachedId;
                }
            }
        }
        try {
            id = this.enumerateImpl(value2, onlyCheckForExisting, saveNewValue);
        }
        catch (Throwable e) {
            if (!this.isCorrupted()) {
                this.markCorrupted();
                LOG.info("Marking corrupted:" + this.myFile, e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        if (this.myDoCaching && id != 0) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                ourEnumerationCache.put(new CacheKey(value2, this), id);
            }
        }
        return id;
    }

    @Override
    public int enumerate(Data value2) throws IOException {
        return this.doEnumerate(value2, false, false);
    }

    protected void putMetaData(long data) {
        this.lockStorageWrite();
        try {
            if (this.myStorage.length() < 12L || this.getMetaData() != data) {
                this.myStorage.putLong(4L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected long getMetaData() {
        this.lockStorageRead();
        try {
            long l = this.myStorage.getLong(4L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    void putMetaData2(long data) {
        this.lockStorageWrite();
        try {
            if (this.myStorage.length() < 20L || this.getMetaData2() != data) {
                this.myStorage.putLong(12L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    long getMetaData2() {
        this.lockStorageRead();
        try {
            long l = this.myStorage.getLong(12L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor2, final @Nullable DataFilter filter2) throws IOException {
        if (processor2 == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(8);
        }
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record2) throws IOException {
                if (filter2 == null || filter2.accept(record2)) {
                    return processor2.process(PersistentEnumeratorBase.this.valueOf(record2));
                }
                return true;
            }
        });
    }

    public abstract boolean traverseAllRecords(RecordsProcessor var1) throws IOException;

    protected abstract int enumerateImpl(Data var1, boolean var2, boolean var3) throws IOException;

    protected boolean isKeyAtIndex(Data value2, int idx) throws IOException {
        if (this.myKeyStorage instanceof InlinedKeyStorage) {
            return false;
        }
        int addr = this.indexToAddr(idx);
        if (this.myKeyStorage.checkBytesAreTheSame(addr, value2)) {
            return true;
        }
        if (this.myDataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy) {
            return false;
        }
        return this.myDataDescriptor.isEqual(this.valueOf(idx), value2);
    }

    protected int writeData(Data value2, int hashCode) {
        try {
            this.markDirty(true);
            int dataOff = this.doWriteData(value2);
            return this.setupValueId(hashCode, dataOff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int doWriteData(Data value2) throws IOException {
        return this.myKeyStorage.append(value2);
    }

    protected int setupValueId(int hashCode, int dataOff) {
        byte[] buf = this.myRecordHandler.getRecordBuffer(this);
        this.myRecordHandler.setupRecord(this, hashCode, dataOff, buf);
        int pos = this.myRecordHandler.recordWriteOffset(this, buf);
        this.myStorage.put(pos, buf, 0, buf.length);
        return pos;
    }

    public boolean iterateData(@NotNull Processor<? super Data> processor2) throws IOException {
        if (processor2 == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(10);
        }
        this.lockStorageWrite();
        try {
            this.myKeyStorage.force();
        }
        finally {
            this.unlockStorageWrite();
        }
        return this.myKeyStorage.processAll(processor2);
    }

    private Path keyStreamFile() {
        return this.myFile.resolveSibling(this.myFile.getFileName() + ".keystream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Data valueOf(int idx) throws IOException {
        if (idx <= 0) {
            return null;
        }
        try {
            this.lockStorageRead();
            try {
                int addr = this.indexToAddr(idx);
                Data Data2 = this.myKeyStorage.read(addr);
                return Data2;
            }
            finally {
                this.unlockStorageRead();
            }
        }
        catch (NoDataException e) {
            this.markCorrupted();
            return null;
        }
        catch (IOException io) {
            this.markCorrupted();
            throw io;
        }
        catch (Throwable e) {
            this.markCorrupted();
            throw new RuntimeException(e);
        }
    }

    int reEnumerate(Data key) throws IOException {
        if (!this.canReEnumerate()) {
            throw new IncorrectOperationException();
        }
        return this.doEnumerate(key, false, true);
    }

    boolean canReEnumerate() {
        return false;
    }

    protected abstract int indexToAddr(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.lockStorageWrite();
            try {
                if (!this.myClosed) {
                    this.myClosed = true;
                    this.doClose();
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    protected void doClose() throws IOException {
        try {
            this.myKeyStorage.close();
            this.flush();
        }
        finally {
            this.myStorage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.myClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.myDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCorrupted() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            return this.myCorrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.lockStorageWrite();
            try {
                if (this.myStorage.isDirty() || this.isDirty()) {
                    this.doFlush();
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    protected void doFlush() throws IOException {
        this.markDirty(false);
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            this.lockStorageWrite();
            try {
                this.myKeyStorage.force();
                this.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markDirty(boolean dirty) throws IOException {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            if (dirty && this.myDirty && !this.myDirtyStatusUpdateInProgress) {
                return;
            }
            this.lockStorageWrite();
            try {
                if (this.myDirty) {
                    if (!dirty) {
                        this.myDirtyStatusUpdateInProgress = true;
                        if (this.myMarkCleanCallback != null) {
                            this.myMarkCleanCallback.flush();
                        }
                        if (!this.myCorrupted) {
                            this.myStorage.putInt(0L, this.myVersion.correctlyClosedMagic);
                            this.myDirty = false;
                        }
                        this.myDirtyStatusUpdateInProgress = false;
                    }
                } else if (dirty) {
                    this.myDirtyStatusUpdateInProgress = true;
                    this.myStorage.putInt(0L, this.myVersion.dirtyMagic);
                    this.myDirtyStatusUpdateInProgress = false;
                    this.myDirty = true;
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markCorrupted() {
        Object object = this.getDataAccessLock();
        synchronized (object) {
            if (!this.myCorrupted) {
                this.myCorrupted = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Marking corrupted:" + this.myFile, new Throwable());
                }
                try {
                    this.markDirty(true);
                    this.force();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        String property2 = System.getProperty("idea.enumerationCacheSize");
        ENUMERATION_CACHE_SIZE = property2 == null ? 8192 : Integer.valueOf(property2);
        ourEnumerationCache = new SLRUMap(ENUMERATION_CACHE_SIZE, ENUMERATION_CACHE_SIZE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordBufferHandler";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataAccessLock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDataObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRecordHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAllDataObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "iterateData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlyweightKey
    extends CacheKey {
        FlyweightKey() {
            super(null, null);
        }

        @Override
        public ShareableKey getStableCopy() {
            return new CacheKey(this.key, this.owner);
        }
    }

    public static abstract class RecordsProcessor {
        private int myKey;

        public abstract boolean process(int var1) throws IOException;

        void setCurrentKey(int key) {
            this.myKey = key;
        }

        int getCurrentKey() {
            return this.myKey;
        }
    }

    public static interface DataFilter {
        public boolean accept(int var1);
    }

    public static class VersionUpdatedException
    extends CorruptedException {
        VersionUpdatedException(@NotNull Path file2) {
            if (file2 == null) {
                VersionUpdatedException.$$$reportNull$$$0(0);
            }
            super("PersistentEnumerator storage corrupted " + file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentEnumeratorBase$VersionUpdatedException", "<init>"));
        }
    }

    public static class CorruptedException
    extends IOException {
        public CorruptedException(Path file2) {
            this("PersistentEnumerator storage corrupted " + file2);
        }

        protected CorruptedException(String message2) {
            super(message2);
        }
    }

    private static class CacheKey
    implements ShareableKey {
        public PersistentEnumeratorBase<?> owner;
        public Object key;

        private CacheKey(Object key, PersistentEnumeratorBase<?> owner) {
            this.key = key;
            this.owner = owner;
        }

        @Override
        public ShareableKey getStableCopy() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.owner.equals(cacheKey.owner);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    static abstract class RecordBufferHandler<T extends PersistentEnumeratorBase<?>> {
        RecordBufferHandler() {
        }

        abstract int recordWriteOffset(T var1, byte[] var2);

        abstract byte @NotNull [] getRecordBuffer(T var1);

        abstract void setupRecord(T var1, int var2, int var3, byte[] var4);
    }

    public static class Version {
        private final int correctlyClosedMagic;
        private final int dirtyMagic;

        public Version(int version) {
            this(247118589 + version, -1161946761);
        }

        private Version(int _correctlyClosedMagic, int _dirtyMagic) {
            this.correctlyClosedMagic = _correctlyClosedMagic;
            this.dirtyMagic = _dirtyMagic;
            assert (this.correctlyClosedMagic != this.dirtyMagic);
        }
    }
}

