/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CoroutineLanguageVersionSettingsUtilKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a,\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010!\u001a\u00020\u001f*\u00020\"2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010#\u001a\u00020\u001f*\u00020$2\u0006\u0010%\u001a\u00020\u001bH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006&"}, d2={"ALLOWED_SCOPE_KINDS", "", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "COROUTINE_CONTEXT_1_2_20_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_1_2_20_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "COROUTINE_CONTEXT_1_2_30_FQ_NAME", "getCOROUTINE_CONTEXT_1_2_30_FQ_NAME", "COROUTINE_CONTEXT_1_3_FQ_NAME", "getCOROUTINE_CONTEXT_1_3_FQ_NAME", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingSuspendCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findEnclosingSuspendFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkingCall", "Lorg/jetbrains/kotlin/psi/KtElement;", "isBuiltInCoroutineContext", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isRestrictsSuspensionReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "frontend"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_2_20_FQ_NAME;
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_2_30_FQ_NAME;
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_3_FQ_NAME;
    @NotNull
    private static final Set<LexicalScopeKind> ALLOWED_SCOPE_KINDS;

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_2_20_FQ_NAME() {
        return COROUTINE_CONTEXT_1_2_20_FQ_NAME;
    }

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_2_30_FQ_NAME() {
        return COROUTINE_CONTEXT_1_2_30_FQ_NAME;
    }

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_3_FQ_NAME() {
        return COROUTINE_CONTEXT_1_3_FQ_NAME;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $this$isBuiltInCoroutineContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltInCoroutineContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Object object = $this$isBuiltInCoroutineContext instanceof PropertyGetterDescriptor ? (PropertyGetterDescriptor)$this$isBuiltInCoroutineContext : null;
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor = object == null ? null : object.getCorrespondingProperty();
        return Intrinsics.areEqual(propertyDescriptor == null ? null : ((object = DescriptorUtilsKt.getFqNameSafe(propertyDescriptor)) == null ? null : Boolean.valueOf(CoroutineLanguageVersionSettingsUtilKt.isBuiltInCoroutineContext((FqName)object, languageVersionSettings))), (Object)true);
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $this$isBuiltInCoroutineContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltInCoroutineContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        return CoroutineLanguageVersionSettingsUtilKt.isBuiltInCoroutineContext(DescriptorUtilsKt.getFqNameSafe($this$isBuiltInCoroutineContext), languageVersionSettings);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final FunctionDescriptor findEnclosingSuspendFunction(@NotNull CallCheckerContext context, @NotNull KtElement checkingCall) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)checkingCall, (String)"checkingCall");
            if (!(context.getResolutionContext() instanceof CallResolutionContext) || Intrinsics.areEqual((Object)((CallResolutionContext)context.getResolutionContext()).call.getCallElement(), (Object)checkingCall)) {
                v0 = context.getScope();
            } else {
                var4_2 = (LexicalScope)context.getTrace().get(BindingContext.LEXICAL_SCOPE, checkingCall);
                var3_3 = var4_2 == null ? context.getScope() : var4_2;
                Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"{\n        context.trace.get(BindingContext.LEXICAL_SCOPE, checkingCall) ?: context.scope\n    }");
                v0 = var3_3;
            }
            scope = v0;
            $this$firstOrNull$iv /* !! */  = ScopeUtilsKt.getParentsWithSelf(scope);
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv /* !! */ ) {
                it = (HierarchicalScope)element$iv;
                $i$a$-firstOrNull-CoroutineCallCheckerKt$findEnclosingSuspendFunction$1 = false;
                if (!(it instanceof LexicalScope) || !CoroutineCallCheckerKt.ALLOWED_SCOPE_KINDS.contains((Object)((LexicalScope)it).getKind())) ** GOTO lbl-1000
                $this$safeAs$iv = ((LexicalScope)it).getOwnerDescriptor();
                $i$f$safeAs = false;
                v1 = $this$safeAs$iv;
                if (!(v1 instanceof FunctionDescriptor)) {
                    v1 = null;
                }
                if (Intrinsics.areEqual((Object)((var13_13 = (FunctionDescriptor)v1) == null ? null : Boolean.valueOf(var13_13.isSuspend())), (Object)true)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block12;
            }
            v3 = null;
        }
        var4_2 = v3;
        if (var4_2 == null) {
            v4 = null;
        } else {
            $this$firstOrNull$iv /* !! */  = var4_2;
            $i$f$cast = false;
            v4 = var3_3 = (LexicalScope)$this$cast$iv;
        }
        if (var3_3 == null) {
            v5 = null;
        } else {
            var4_2 = var3_3.getOwnerDescriptor();
            if (var4_2 == null) {
                v5 = null;
            } else {
                $this$cast$iv = var4_2;
                $i$f$cast = false;
                v5 = (FunctionDescriptor)$this$cast$iv;
            }
        }
        return v5;
    }

    private static final boolean isScopeForDefaultParameterValuesOf(HierarchicalScope $this$isScopeForDefaultParameterValuesOf, FunctionDescriptor enclosingSuspendFunction) {
        return $this$isScopeForDefaultParameterValuesOf instanceof LexicalScope && ((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual((Object)((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getOwnerDescriptor(), (Object)enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines)) {
            if (languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) < 0) {
                diagnosticHolder.report(Errors.UNSUPPORTED.on(reportOn, "cannot use release coroutines with api version less than 1.3"));
            }
            return;
        }
        Pair diagnosticData = TuplesKt.to((Object)((Object)LanguageFeature.Coroutines), (Object)languageVersionSettings);
        LanguageFeature.State state = languageVersionSettings.getFeatureSupport(LanguageFeature.Coroutines);
        int n = WhenMappings.$EnumSwitchMapping$0[state.ordinal()];
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 3: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 4: {
                diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
            }
        }
    }

    public static final boolean isRestrictsSuspensionReceiver(@NotNull KotlinType $this$isRestrictsSuspensionReceiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isRestrictsSuspensionReceiver, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$this$isRestrictsSuspensionReceiver), (Iterable)TypeUtilsKt.supertypes($this$isRestrictsSuspensionReceiver));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Annotations annotations2;
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                    if (!Intrinsics.areEqual(classifierDescriptor == null ? null : ((annotations2 = classifierDescriptor.getAnnotations()) == null ? null : Boolean.valueOf(annotations2.hasAnnotation(CoroutineLanguageVersionSettingsUtilKt.restrictsSuspensionFqName(languageVersionSettings)))), (Object)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = enclosingSuspendCallableDescriptor.getExtensionReceiverParameter();
        ReceiverValue enclosingSuspendExtensionReceiverValue = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getValue();
        ReceiverParameterDescriptor receiverParameterDescriptor2 = enclosingSuspendCallableDescriptor.getDispatchReceiverParameter();
        ReceiverValue enclosingSuspendDispatchReceiverValue = receiverParameterDescriptor2 == null ? null : receiverParameterDescriptor2.getValue();
        Object object = new ReceiverValue[]{resolvedCall2.getDispatchReceiver(), resolvedCall2.getExtensionReceiver()};
        List receivers = CollectionsKt.listOfNotNull((Object[])object);
        for (ReceiverValue receiverValue : receivers) {
            ReceiverValue receiverValue2;
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"receiverValue");
            if (!CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue, context2) || Intrinsics.areEqual((receiverValue2 = enclosingSuspendExtensionReceiverValue) == null ? null : Boolean.valueOf(CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue2, context2, receiverValue)), (Object)true) || Intrinsics.areEqual((receiverValue2 = enclosingSuspendDispatchReceiverValue) == null ? null : Boolean.valueOf(CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue2, context2, receiverValue)), (Object)true)) continue;
            CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context2, reportOn);
            return;
        }
        object = enclosingSuspendExtensionReceiverValue;
        if (!Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver((ReceiverValue)object, context2))), (Object)true)) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context2, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context2, resolvedCall2.getExtensionReceiver())) {
            ReceiverParameterDescriptor receiverParameterDescriptor3 = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor3);
            object = receiverParameterDescriptor3.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolvedCall.candidateDescriptor.extensionReceiverParameter!!.value");
            if (CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver((ReceiverValue)object, context2)) {
                return;
            }
        }
        CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context2, reportOn);
    }

    private static final boolean checkRestrictsSuspension$isRestrictsSuspensionReceiver(ReceiverValue $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver, CallCheckerContext $context) {
        KotlinType kotlinType = $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
        return CoroutineCallCheckerKt.isRestrictsSuspensionReceiver(kotlinType, $context.getLanguageVersionSettings());
    }

    private static final boolean checkRestrictsSuspension$sameInstance(ReceiverValue $this$checkRestrictsSuspension_u24sameInstance, CallCheckerContext $context, ReceiverValue other) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        DeclarationDescriptor declarationDescriptor;
        if (other == null) {
            return false;
        }
        if ($this$checkRestrictsSuspension_u24sameInstance.getOriginal() == other.getOriginal()) {
            return true;
        }
        Object object = other instanceof ExpressionReceiver ? (ExpressionReceiver)other : null;
        KtExpression ktExpression = object == null ? null : object.getExpression();
        KtThisExpression ktThisExpression = ktExpression instanceof KtThisExpression ? (KtThisExpression)ktExpression : null;
        KtReferenceExpression referenceExpression = ktThisExpression == null ? null : ktThisExpression.getInstanceReference();
        if ((ktExpression = referenceExpression) == null) {
            declarationDescriptor = null;
        } else {
            object = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            declarationDescriptor = (DeclarationDescriptor)$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
        }
        DeclarationDescriptor referenceTarget = declarationDescriptor;
        object = referenceTarget;
        ReceiverValue referenceReceiverValue = object instanceof CallableDescriptor ? ((receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter()) == null ? null : receiverParameterDescriptor.getValue()) : (object instanceof ClassDescriptor ? ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getValue() : null);
        return $this$checkRestrictsSuspension_u24sameInstance == referenceReceiverValue;
    }

    private static final void checkRestrictsSuspension$reportError(CallCheckerContext $context, PsiElement $reportOn) {
        $context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on($reportOn));
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingSuspendCallableDescriptor, resolvedCall2, reportOn, context2);
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    static {
        LexicalScopeKind[] lexicalScopeKindArray = StandardNames.COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("coroutineContext"));
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScopeKindArray, (String)"COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_1_2_20_FQ_NAME = lexicalScopeKindArray;
        lexicalScopeKindArray = StandardNames.COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("coroutineContext"));
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScopeKindArray, (String)"COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_1_2_30_FQ_NAME = lexicalScopeKindArray;
        lexicalScopeKindArray = StandardNames.COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("coroutineContext"));
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScopeKindArray, (String)"COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_1_3_FQ_NAME = lexicalScopeKindArray;
        lexicalScopeKindArray = new LexicalScopeKind[]{LexicalScopeKind.FUNCTION_INNER_SCOPE, LexicalScopeKind.FUNCTION_HEADER_FOR_DESTRUCTURING};
        ALLOWED_SCOPE_KINDS = SetsKt.setOf((Object[])lexicalScopeKindArray);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageFeature.State.values().length];
            nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 2;
            nArray[LanguageFeature.State.ENABLED_WITH_ERROR.ordinal()] = 3;
            nArray[LanguageFeature.State.DISABLED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

