/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.PersistentMultimap;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003BG\b\u0002\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00062\u001c\u0010\u001b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016J$\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0 H\u0016J(\u0010!\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00062\u0016\u0010\u001b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u001a0 H\u0016J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u0012\u0010+\u001a\u00020\u00002\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "()V", "properties", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "functions", "Lorg/jetbrains/kotlin/fir/resolve/PersistentMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "classes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/resolve/PersistentMultimap;Lkotlinx/collections/immutable/PersistentMap;)V", "getClasses", "()Lkotlinx/collections/immutable/PersistentMap;", "getFunctions", "()Lorg/jetbrains/kotlin/fir/resolve/PersistentMultimap;", "getProperties", "getCallableNames", "", "getClassifierNames", "mayContainName", "", "name", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "processPropertiesByName", "storeBackingField", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "storeClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "storeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "storeVariable", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "resolve"})
public final class FirLocalScope
extends FirScope
implements FirContainingNamesAwareScope {
    @NotNull
    private final PersistentMap<Name, FirVariableSymbol<?>> properties;
    @NotNull
    private final PersistentMultimap<Name, FirNamedFunctionSymbol> functions;
    @NotNull
    private final PersistentMap<Name, FirRegularClassSymbol> classes;

    private FirLocalScope(PersistentMap<Name, ? extends FirVariableSymbol<?>> properties2, PersistentMultimap<Name, FirNamedFunctionSymbol> functions2, PersistentMap<Name, FirRegularClassSymbol> classes2) {
        this.properties = properties2;
        this.functions = functions2;
        this.classes = classes2;
    }

    @NotNull
    public final PersistentMap<Name, FirVariableSymbol<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final PersistentMultimap<Name, FirNamedFunctionSymbol> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final PersistentMap<Name, FirRegularClassSymbol> getClasses() {
        return this.classes;
    }

    public FirLocalScope() {
        this(ExtensionsKt.persistentMapOf(new Pair[0]), new PersistentMultimap<Name, FirNamedFunctionSymbol>(), ExtensionsKt.persistentMapOf(new Pair[0]));
    }

    @NotNull
    public final FirLocalScope storeClass(@NotNull FirRegularClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return new FirLocalScope(this.properties, this.functions, this.classes.put(klass.getName(), klass.getSymbol()));
    }

    @NotNull
    public final FirLocalScope storeFunction(@NotNull FirSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return new FirLocalScope(this.properties, this.functions.put(function2.getName(), function2.getSymbol()), this.classes);
    }

    @NotNull
    public final FirLocalScope storeVariable(@NotNull FirVariable<?> variable2) {
        Intrinsics.checkNotNullParameter(variable2, (String)"variable");
        return new FirLocalScope(this.properties.put(variable2.getName(), variable2.getSymbol()), this.functions, this.classes);
    }

    @NotNull
    public final FirLocalScope storeBackingField(@NotNull FirProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return new FirLocalScope(this.properties.put(DefaultNamesKt.getNAME_FOR_BACKING_FIELD(), property2.getBackingFieldSymbol()), this.functions, this.classes);
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        for (FirNamedFunctionSymbol function2 : this.functions.get(name)) {
            processor2.invoke((Object)function2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        FirVariableSymbol property2 = (FirVariableSymbol)this.properties.get(name);
        if (property2 != null) {
            processor2.invoke((Object)property2);
        }
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        FirRegularClassSymbol klass = (FirRegularClassSymbol)this.classes.get(name);
        if (klass != null) {
            processor2.invoke((Object)klass, (Object)ConeSubstitutor.Empty.INSTANCE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mayContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.properties.containsKey(name)) return true;
        Collection collection = this.functions.get(name);
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!this.classes.containsKey(name)) return false;
        return true;
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.plus(this.properties.keySet(), (Iterable)this.functions.getKeys());
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return this.classes.keySet();
    }
}

