/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutorByMap;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "substitution", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Ljava/util/Map;)V", "getSubstitution", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "substituteType", "type", "toString", "", "resolve"})
public final class ConeSubstitutorByMap
extends AbstractConeSubstitutor {
    @NotNull
    private final Map<FirTypeParameterSymbol, ConeKotlinType> substitution;

    public ConeSubstitutorByMap(@NotNull Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution) {
        Intrinsics.checkNotNullParameter(substitution, (String)"substitution");
        this.substitution = substitution;
    }

    @NotNull
    public final Map<FirTypeParameterSymbol, ConeKotlinType> getSubstitution() {
        return this.substitution;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof ConeTypeParameterType)) {
            return null;
        }
        ConeKotlinType coneKotlinType = this.updateNullabilityIfNeeded(this.substitution.get(((ConeTypeParameterType)type2).getLookupTag().getSymbol()), type2);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType result2 = coneKotlinType;
        FirSession session2 = ((FirTypeParameter)((ConeTypeParameterType)type2).getLookupTag().getSymbol().getFir()).getSession();
        if (TypeUtilsKt.isUnsafeVarianceType(type2, session2)) {
            KotlinTypeMarker kotlinTypeMarker = InferenceComponentsKt.getInferenceComponents(session2).getApproximator().approximateToSuperType(result2, TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
            ConeKotlinType coneKotlinType2 = kotlinTypeMarker instanceof ConeKotlinType ? (ConeKotlinType)kotlinTypeMarker : null;
            return coneKotlinType2 == null ? result2 : coneKotlinType2;
        }
        return result2;
    }

    @NotNull
    public final Map<FirTypeParameterSymbol, ConeKotlinType> component1() {
        return this.substitution;
    }

    @NotNull
    public final ConeSubstitutorByMap copy(@NotNull Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution) {
        Intrinsics.checkNotNullParameter(substitution, (String)"substitution");
        return new ConeSubstitutorByMap(substitution);
    }

    public static /* synthetic */ ConeSubstitutorByMap copy$default(ConeSubstitutorByMap coneSubstitutorByMap, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = coneSubstitutorByMap.substitution;
        }
        return coneSubstitutorByMap.copy(map);
    }

    @NotNull
    public String toString() {
        return "ConeSubstitutorByMap(substitution=" + this.substitution + ')';
    }

    public int hashCode() {
        return ((Object)this.substitution).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConeSubstitutorByMap)) {
            return false;
        }
        ConeSubstitutorByMap coneSubstitutorByMap = (ConeSubstitutorByMap)other;
        return Intrinsics.areEqual(this.substitution, coneSubstitutorByMap.substitution);
    }
}

