/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.PrimitiveTypes;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.backend.PrimitiveConeNumericComparisonInfo;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\n*\u00020\u000eH\u0002\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\nH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0010"}, d2={"left", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "getLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "right", "getRight", "inferPrimitiveNumericComparisonInfo", "Lorg/jetbrains/kotlin/fir/backend/PrimitiveConeNumericComparisonInfo;", "leastCommonPrimitiveNumericType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "t1", "t2", "getPrimitiveTypeOrSupertype", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "promoteIntegerTypeToIntIfRequired", "fir2ir"})
public final class PrimitiveComparisonKt {
    @NotNull
    public static final FirExpression getLeft(@NotNull FirComparisonExpression $this$left) {
        Intrinsics.checkNotNullParameter((Object)$this$left, (String)"<this>");
        FirExpression firExpression2 = $this$left.getCompareToCall().getExplicitReceiver();
        if (firExpression2 == null) {
            String string2 = Intrinsics.stringPlus((String)"There should be an explicit receiver for ", (Object)FirRendererKt.render$default($this$left.getCompareToCall(), null, 1, null));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firExpression2;
    }

    @NotNull
    public static final FirExpression getRight(@NotNull FirComparisonExpression $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        FirCall $this$arguments$iv = $this$right.getCompareToCall();
        boolean $i$f$getArguments = false;
        FirExpression firExpression2 = (FirExpression)CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), (int)0);
        if (firExpression2 == null) {
            String string2 = Intrinsics.stringPlus((String)"There should be a first arg for ", (Object)FirRendererKt.render$default($this$right.getCompareToCall(), null, 1, null));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firExpression2;
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull FirComparisonExpression $this$inferPrimitiveNumericComparisonInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$inferPrimitiveNumericComparisonInfo, (String)"<this>");
        return PrimitiveComparisonKt.inferPrimitiveNumericComparisonInfo(PrimitiveComparisonKt.getLeft($this$inferPrimitiveNumericComparisonInfo), PrimitiveComparisonKt.getRight($this$inferPrimitiveNumericComparisonInfo));
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull FirExpression left, @NotNull FirExpression right) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        FirTypeRef $this$coneType$iv = left.getTypeRef();
        boolean $i$f$getConeType = false;
        Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType3 instanceof ConeKotlinType)) {
            coneKotlinType3 = null;
        }
        if ((coneKotlinType2 = coneKotlinType3) == null) {
            $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
            $i$f$coneTypeSafe = false;
            throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
        }
        ConeKotlinType leftType = coneKotlinType2;
        FirTypeRef $this$coneType$iv2 = right.getTypeRef();
        boolean $i$f$getConeType22 = false;
        Object $this$coneTypeSafe$iv$iv2 = $this$coneType$iv2;
        boolean $i$f$coneTypeSafe2 = false;
        boolean bl2 = false;
        FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv$iv2 instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv2 : null;
        ConeKotlinType coneKotlinType4 = firResolvedTypeRef2 == null ? null : firResolvedTypeRef2.getType();
        if (!(coneKotlinType4 instanceof ConeKotlinType)) {
            coneKotlinType4 = null;
        }
        if ((coneKotlinType = coneKotlinType4) == null) {
            $this$coneTypeSafe$iv$iv2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv2.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv2, null, 1, null);
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv2.toString());
        }
        ConeKotlinType rightType = coneKotlinType;
        ConeClassLikeType $i$f$getConeType22 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(leftType);
        if ($i$f$getConeType22 == null) {
            return null;
        }
        ConeClassLikeType leftPrimitiveOrNullableType = $i$f$getConeType22;
        $this$coneTypeSafe$iv$iv2 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(rightType);
        if ($this$coneTypeSafe$iv$iv2 == null) {
            return null;
        }
        Object rightPrimitiveOrNullableType = $this$coneTypeSafe$iv$iv2;
        ConeClassLikeType leastCommonType = PrimitiveComparisonKt.leastCommonPrimitiveNumericType(leftPrimitiveOrNullableType, (ConeClassLikeType)rightPrimitiveOrNullableType);
        return new PrimitiveConeNumericComparisonInfo(leastCommonType, leftPrimitiveOrNullableType, (ConeClassLikeType)rightPrimitiveOrNullableType);
    }

    private static final ConeClassLikeType leastCommonPrimitiveNumericType(ConeClassLikeType t1, ConeClassLikeType t2) {
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType pt1 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t1);
        ConeClassLikeType pt2 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t2);
        if (PrimitivesKt.isDouble(pt1) || PrimitivesKt.isDouble(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getDouble();
        } else if (PrimitivesKt.isFloat(pt1) || PrimitivesKt.isFloat(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getFloat();
        } else if (PrimitivesKt.isLong(pt1) || PrimitivesKt.isLong(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getLong();
        } else if (PrimitivesKt.isInt(pt1) || PrimitivesKt.isInt(pt2)) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getInt();
        } else {
            String string2 = "Unexpected types: t1=" + t1 + ", t2=" + t2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType promoteIntegerTypeToIntIfRequired(ConeClassLikeType $this$promoteIntegerTypeToIntIfRequired) {
        ConeClassLikeType coneClassLikeType;
        ClassId classId = $this$promoteIntegerTypeToIntIfRequired.getLookupTag().getClassId();
        if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort())) {
            coneClassLikeType = PrimitiveTypes.INSTANCE.getInt();
        } else if ((((Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt())) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getFloat())) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getDouble())) ? true : Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getChar())) {
            coneClassLikeType = $this$promoteIntegerTypeToIntIfRequired;
        } else {
            String string2 = Intrinsics.stringPlus((String)"Primitive number type expected: ", (Object)$this$promoteIntegerTypeToIntIfRequired);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType getPrimitiveTypeOrSupertype(ConeKotlinType $this$getPrimitiveTypeOrSupertype) {
        ConeClassLikeType coneClassLikeType;
        block5: {
            if ($this$getPrimitiveTypeOrSupertype instanceof ConeTypeParameterType) {
                Iterable $this$firstNotNullResult$iv = ((FirTypeParameter)((ConeTypeParameterType)$this$getPrimitiveTypeOrSupertype).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
                boolean $i$f$firstNotNullResult = false;
                for (Object element$iv : $this$firstNotNullResult$iv) {
                    ConeKotlinType coneKotlinType;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl = false;
                    FirTypeRef $this$coneType$iv = it;
                    boolean $i$f$getConeType = false;
                    FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl2 = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                    ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                        coneKotlinType2 = null;
                    }
                    if ((coneKotlinType = coneKotlinType2) == null) {
                        String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                        boolean bl3 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    ConeClassLikeType result$iv = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(coneKotlinType);
                    if (result$iv == null) continue;
                    coneClassLikeType = result$iv;
                    break block5;
                }
                coneClassLikeType = null;
            } else {
                coneClassLikeType = $this$getPrimitiveTypeOrSupertype instanceof ConeClassLikeType && PrimitivesKt.isPrimitiveNumberType((ConeClassLikeType)$this$getPrimitiveTypeOrSupertype) ? (ConeClassLikeType)$this$getPrimitiveTypeOrSupertype : ($this$getPrimitiveTypeOrSupertype instanceof ConeFlexibleType ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(((ConeFlexibleType)$this$getPrimitiveTypeOrSupertype).getLowerBound()) : null);
            }
        }
        return coneClassLikeType;
    }
}

