/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElementImpl;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "Lorg/jetbrains/kotlin/psi/KtElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "getContainingDoc", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "getContainingSection", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getNameText", "", "getNameTextRange", "Lcom/intellij/openapi/util/TextRange;", "getQualifiedName", "", "getQualifier", "psi"})
public final class KDocName
extends KtElementImpl {
    @NotNull
    public final KDoc getContainingDoc() {
        KDoc kdoc;
        KDocName $this$getStrictParentOfType$iv = this;
        boolean $i$f$getStrictParentOfType = false;
        KDoc kDoc = kdoc = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KDoc.class, true);
        if (kDoc == null) {
            throw (Throwable)new IllegalStateException("KDocName must be inside a KDoc");
        }
        return kDoc;
    }

    @NotNull
    public final KDocSection getContainingSection() {
        KDocSection kdoc;
        KDocName $this$getStrictParentOfType$iv = this;
        boolean $i$f$getStrictParentOfType = false;
        KDocSection kDocSection = kdoc = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KDocSection.class, true);
        if (kDocSection == null) {
            throw (Throwable)new IllegalStateException("KDocName must be inside a KDocSection");
        }
        return kDocSection;
    }

    @Nullable
    public final KDocName getQualifier() {
        KDocName $this$getChildOfType$iv = this;
        boolean $i$f$getChildOfType = false;
        return PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KDocName.class);
    }

    @NotNull
    public final TextRange getNameTextRange() {
        int n;
        ASTNode dot = this.getNode().findChildByType(KtTokens.DOT);
        TextRange textRange = this.getTextRange();
        if (dot != null) {
            TextRange textRange2 = dot.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"dot.textRange");
            int n2 = textRange2.getEndOffset();
            TextRange textRange3 = textRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange3, (String)"textRange");
            n = n2 - textRange3.getStartOffset();
        } else {
            n = 0;
        }
        int nameStart = n;
        TextRange textRange4 = textRange;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange4, (String)"textRange");
        return new TextRange(nameStart, textRange4.getLength());
    }

    @NotNull
    public final String getNameText() {
        String string2 = this.getNameTextRange().substring(this.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getNameTextRange().substring(text)");
        return string2;
    }

    @NotNull
    public final List<String> getQualifiedName() {
        KDocName qualifier = this.getQualifier();
        List nameAsList = CollectionsKt.listOf((Object)this.getNameText());
        return qualifier != null ? CollectionsKt.plus((Collection)qualifier.getQualifiedName(), (Iterable)nameAsList) : nameAsList;
    }

    public KDocName(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }
}

