/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001c\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a.\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"canHaveSideEffects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getCanHaveSideEffects", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Z", "constLongValue", "", "getConstLongValue", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Ljava/lang/Long;", "castIfNecessary", "targetType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "numberCastFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "createTemporaryVariableIfNecessary", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "expression", "nameHint", "", "decrement", "negate", "ir.backend.common"})
public final class UtilsKt {
    @NotNull
    public static final IrExpression castIfNecessary(@NotNull IrExpression $this$castIfNecessary, @NotNull IrType targetType, @NotNull Name numberCastFunctionName) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$castIfNecessary, (String)"$this$castIfNecessary");
        Intrinsics.checkParameterIsNotNull((Object)targetType, (String)"targetType");
        Intrinsics.checkParameterIsNotNull((Object)numberCastFunctionName, (String)"numberCastFunctionName");
        if (Intrinsics.areEqual((Object)$this$castIfNecessary.getType(), (Object)targetType) || IrTypePredicatesKt.isNothing($this$castIfNecessary.getType())) {
            irExpression = $this$castIfNecessary;
        } else {
            IrClass irClass = IrTypesKt.getClass($this$castIfNecessary.getType());
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)numberCastFunctionName) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction castFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$castIfNecessary.getStartOffset(), $this$castIfNecessary.getEndOffset(), castFun.getReturnType(), castFun.getSymbol(), null, null, 48, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$castIfNecessary);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    @NotNull
    public static final IrExpression negate(@NotNull IrExpression $this$negate) {
        IrExpressionBase irExpressionBase;
        Number value2;
        Intrinsics.checkParameterIsNotNull((Object)$this$negate, (String)"$this$negate");
        IrExpression irExpression = $this$negate;
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        Object object = irConst != null ? irConst.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        if ((value2 = (Number)object) instanceof Integer) {
            irExpressionBase = new IrConstImpl<Integer>($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Int.INSTANCE, -value2.intValue());
        } else if (value2 instanceof Long) {
            irExpressionBase = new IrConstImpl<Long>($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), IrConstKind.Long.INSTANCE, -value2.longValue());
        } else {
            if (IrTypePredicatesKt.isNothing($this$negate.getType())) {
                return $this$negate;
            }
            IrClass irClass = IrTypesKt.getClass($this$negate.getType());
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.UNARY_MINUS) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction unaryMinusFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$negate.getStartOffset(), $this$negate.getEndOffset(), $this$negate.getType(), unaryMinusFun.getSymbol(), null, null, 48, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$negate);
            irExpressionBase = irCallImpl;
        }
        return irExpressionBase;
    }

    @NotNull
    public static final IrExpression decrement(@NotNull IrExpression $this$decrement) {
        IrExpressionBase irExpressionBase;
        Object thisValue;
        Intrinsics.checkParameterIsNotNull((Object)$this$decrement, (String)"$this$decrement");
        IrExpression irExpression = $this$decrement;
        if (!(irExpression instanceof IrConst)) {
            irExpression = null;
        }
        IrConst irConst = (IrConst)irExpression;
        Object object = thisValue = irConst != null ? irConst.getValue() : null;
        if (thisValue instanceof Integer) {
            irExpressionBase = new IrConstImpl<Integer>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Int.INSTANCE, ((Number)thisValue).intValue() - 1);
        } else if (thisValue instanceof Long) {
            irExpressionBase = new IrConstImpl<Long>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Long.INSTANCE, ((Number)thisValue).longValue() - 1L);
        } else if (thisValue instanceof Character) {
            irExpressionBase = new IrConstImpl<Character>($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), IrConstKind.Char.INSTANCE, Character.valueOf((char)(((Character)thisValue).charValue() - '\u0001')));
        } else {
            IrClass irClass = IrTypesKt.getClass($this$decrement.getType());
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.DEC) && it.getValueParameters().isEmpty())) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            IrSimpleFunction decFun = single$iv;
            IrCallImpl irCallImpl = new IrCallImpl($this$decrement.getStartOffset(), $this$decrement.getEndOffset(), $this$decrement.getType(), decFun.getSymbol(), null, null, 48, null);
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl $this$apply = irCallImpl;
            boolean bl3 = false;
            $this$apply.setDispatchReceiver($this$decrement);
            irExpressionBase = irCallImpl;
        }
        return irExpressionBase;
    }

    public static final boolean getCanHaveSideEffects(@NotNull IrExpression $this$canHaveSideEffects) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canHaveSideEffects, (String)"$this$canHaveSideEffects");
        return !($this$canHaveSideEffects instanceof IrConst) && !($this$canHaveSideEffects instanceof IrGetValue);
    }

    @Nullable
    public static final Long getConstLongValue(@NotNull IrExpression $this$constLongValue) {
        Object value2;
        Intrinsics.checkParameterIsNotNull((Object)$this$constLongValue, (String)"$this$constLongValue");
        return $this$constLongValue instanceof IrConst ? ((value2 = ((IrConst)$this$constLongValue).getValue()) instanceof Number ? Long.valueOf(((Number)value2).longValue()) : (value2 instanceof Character ? Long.valueOf(((Character)value2).charValue()) : null)) : null;
    }

    @NotNull
    public static final Pair<IrVariable, IrExpression> createTemporaryVariableIfNecessary(@NotNull DeclarationIrBuilder $this$createTemporaryVariableIfNecessary, @NotNull IrExpression expression2, @Nullable String nameHint) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)$this$createTemporaryVariableIfNecessary, (String)"$this$createTemporaryVariableIfNecessary");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (UtilsKt.getCanHaveSideEffects(expression2)) {
            IrVariable irVariable2 = IrBuildersKt.createTmpVariable$default($this$createTemporaryVariableIfNecessary.getScope(), expression2, nameHint, false, null, null, 28, null);
            boolean bl = false;
            boolean bl2 = false;
            IrVariable it = irVariable2;
            boolean bl3 = false;
            pair = new Pair((Object)it, (Object)ExpressionHelpersKt.irGet($this$createTemporaryVariableIfNecessary, it));
        } else {
            pair = new Pair(null, (Object)expression2);
        }
        return pair;
    }

    public static /* synthetic */ Pair createTemporaryVariableIfNecessary$default(DeclarationIrBuilder declarationIrBuilder, IrExpression irExpression, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return UtilsKt.createTemporaryVariableIfNecessary(declarationIrBuilder, irExpression, string2);
    }
}

