/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.DeprecatedMethodException;
import java.io.IOException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataReader {
    private static final Logger LOG = Logger.getInstance(BaseDataReader.class);
    protected final SleepingPolicy mySleepingPolicy;
    protected final Object mySleepMonitor = new Object();
    protected volatile boolean isStopped;
    private Future<?> myFinishedFuture;

    public BaseDataReader(SleepingPolicy sleepingPolicy) {
        this.mySleepingPolicy = sleepingPolicy != null ? sleepingPolicy : SleepingPolicy.NON_BLOCKING;
    }

    protected void start(@NotNull String presentableName2) {
        if (presentableName2 == null) {
            BaseDataReader.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces(presentableName2)) {
            LOG.warn(new Throwable("Must provide not-empty presentable name"));
        }
        if (this.myFinishedFuture == null) {
            this.myFinishedFuture = this.executeOnPooledThread(() -> {
                if (StringUtil.isEmptyOrSpaces(presentableName2)) {
                    this.doRun();
                } else {
                    ConcurrencyUtil.runUnderThreadName("BaseDataReader: " + presentableName2, this::doRun);
                }
            });
        }
    }

    protected boolean readAvailable() throws IOException {
        return this.mySleepingPolicy == SleepingPolicy.BLOCKING ? this.readAvailableBlocking() : this.readAvailableNonBlocking();
    }

    protected boolean readAvailableNonBlocking() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean readAvailableBlocking() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract Future<?> executeOnPooledThread(@NotNull Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        try {
            boolean stopSignalled = false;
            while (true) {
                boolean read2 = this.readAvailable();
                if (stopSignalled) return;
                if (this.mySleepingPolicy == SleepingPolicy.BLOCKING) {
                    return;
                }
                stopSignalled = this.isStopped;
                if (stopSignalled) continue;
                this.beforeSleeping(read2);
                Object object = this.mySleepMonitor;
                synchronized (object) {
                    this.mySleepMonitor.wait(this.mySleepingPolicy.getTimeToSleep(read2));
                }
            }
        }
        catch (IOException e) {
            LOG.info(e);
            return;
        }
        catch (Exception e) {
            LOG.error(e);
            return;
        }
        finally {
            this.flush();
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.error("Can't close stream", e);
            }
        }
    }

    protected void flush() {
    }

    protected void beforeSleeping(boolean hasJustReadSomething) {
    }

    protected abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.isStopped = true;
        Object object = this.mySleepMonitor;
        synchronized (object) {
            this.mySleepMonitor.notifyAll();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected void start() {
        DeprecatedMethodException.report("Use start(String) instead");
        this.start("");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/util/io/BaseDataReader", "start"));
    }

    public static interface SleepingPolicy {
        public static final SleepingPolicy NON_BLOCKING = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return wasActive ? 1 : 5;
            }
        };
        public static final SleepingPolicy BLOCKING = new SleepingPolicy(){

            @Override
            public int getTimeToSleep(boolean wasActive) {
                return 50;
            }
        };
        @Deprecated
        public static final SleepingPolicy SIMPLE = NON_BLOCKING;

        public int getTimeToSleep(boolean var1);
    }
}

