/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "oldLoopToNewLoop", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/util/Map;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "headerProcessor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "iteratorToLoopHeader", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "getLoopHeader", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "processHeader", "Lorg/jetbrains/kotlin/ir/IrStatement;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "processNext", "visitVariable", "declaration", "visitWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "ir.backend.common"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    private final Symbols<CommonBackendContext> symbols;
    private final Map<IrVariableSymbol, ForLoopHeader> iteratorToLoopHeader;
    private final HeaderInfoBuilder headerInfoBuilder;
    private final HeaderProcessor headerProcessor;
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        return scopeWithIr.getScope().getScopeOwnerSymbol();
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration2) {
        IrStatement irStatement;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrExpression initializer2 = declaration2.getInitializer();
        if (initializer2 == null || !(initializer2 instanceof IrCall)) {
            return super.visitVariable(declaration2);
        }
        IrStatementOrigin irStatementOrigin = ((IrCall)initializer2).getOrigin();
        if ((Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.FOR_LOOP_ITERATOR.INSTANCE) ? this.processHeader(declaration2) : (irStatement = Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE) ? (IrStatement)this.processNext(declaration2) : null)) == null) {
            irStatement = super.visitVariable(declaration2);
        }
        return irStatement;
    }

    private final IrStatement processHeader(IrVariable variable2) {
        Map<IrVariableSymbol, ForLoopHeader> map2 = this.iteratorToLoopHeader;
        Object s = variable2.getSymbol();
        boolean bl = false;
        Map<IrVariableSymbol, ForLoopHeader> map3 = map2;
        boolean bl2 = false;
        boolean bl3 = !map3.containsKey(s);
        boolean bl4 = false;
        bl = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ForLoopHeader forLoopHeader = this.headerProcessor.processHeader(variable2);
        if (forLoopHeader == null) {
            return null;
        }
        ForLoopHeader forLoopInfo = forLoopHeader;
        this.iteratorToLoopHeader.put((IrVariableSymbol)variable2.getSymbol(), forLoopInfo);
        return new IrCompositeImpl(variable2.getStartOffset(), variable2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, forLoopInfo.getDeclarations());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2) {
        void newLoop;
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        if (Intrinsics.areEqual((Object)loop2.getOrigin(), (Object)IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE) ^ true) {
            return super.visitWhileLoop(loop2);
        }
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop2.getStartOffset(), loop2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = declarationIrBuilder;
        boolean bl3 = false;
        IrExpression irExpression2 = loop2.getBody();
        if (irExpression2 != null && (irExpression2 = irExpression2.transform(this, null)) != null) {
            IrExpression irExpression3 = irExpression2;
            boolean bl4 = false;
            boolean bl5 = false;
            IrExpression it = irExpression3;
            boolean bl6 = false;
            irExpression = it instanceof IrContainerExpression && !((IrContainerExpression)it).isTransparentScope() ? (IrExpression)new IrCompositeImpl($this$with.getStartOffset(), $this$with.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        } else {
            irExpression = null;
        }
        IrExpression newBody = irExpression;
        ForLoopHeader forLoopHeader = this.getLoopHeader(loop2.getCondition());
        if (forLoopHeader == null) {
            return super.visitWhileLoop(loop2);
        }
        ForLoopHeader loopHeader = forLoopHeader;
        LoopReplacement loopReplacement = loopHeader.buildLoop($this$with, loop2, newBody);
        IrLoop irLoop = loopReplacement.component1();
        IrExpression replacementExpression = loopReplacement.component2();
        this.oldLoopToNewLoop.put(loop2, (IrLoop)newLoop);
        return replacementExpression;
    }

    private final ForLoopHeader getLoopHeader(IrExpression expression2) {
        if (!(expression2 instanceof IrCall) || Intrinsics.areEqual((Object)((IrCall)expression2).getOrigin(), (Object)IrStatementOrigin.FOR_LOOP_HAS_NEXT.INSTANCE) ^ true && Intrinsics.areEqual((Object)((IrCall)expression2).getOrigin(), (Object)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE) ^ true) {
            return null;
        }
        IrExpression irExpression = ((IrCall)expression2).getDispatchReceiver();
        if (irExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
        }
        IrGetValue iterator2 = (IrGetValue)irExpression;
        Map<IrVariableSymbol, ForLoopHeader> map2 = this.iteratorToLoopHeader;
        IrValueSymbol irValueSymbol = iterator2.getSymbol();
        boolean bl = false;
        return map2.get(irValueSymbol);
    }

    private final IrExpression processNext(IrVariable variable2) {
        IrExpression irExpression = variable2.getInitializer();
        if (irExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
        }
        IrCall initializer2 = (IrCall)irExpression;
        ForLoopHeader forLoopHeader = this.getLoopHeader(initializer2);
        if (forLoopHeader == null) {
            return null;
        }
        ForLoopHeader forLoopInfo = forLoopHeader;
        forLoopInfo.setLoopVariable(variable2);
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer2.getStartOffset(), initializer2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = declarationIrBuilder;
        boolean bl3 = false;
        variable2.setInitializer(forLoopInfo.initializeLoopVariable(this.symbols, $this$with));
        IrStatement increment = forLoopInfo.incrementInductionVariable($this$with);
        return new IrCompositeImpl(variable2.getStartOffset(), variable2.getEndOffset(), $this$with.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE, CollectionsKt.listOf((Object[])new IrStatement[]{variable2, increment}));
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    public RangeLoopTransformer(@NotNull CommonBackendContext context2, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(oldLoopToNewLoop, (String)"oldLoopToNewLoop");
        this.context = context2;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.symbols = this.context.getIr().getSymbols();
        RangeLoopTransformer rangeLoopTransformer = this;
        boolean bl = false;
        rangeLoopTransformer.iteratorToLoopHeader = map2 = (Map)new LinkedHashMap();
        this.headerInfoBuilder = new HeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        }));
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        }));
    }
}

