/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.diagnostic.LoadingPhase;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IElementType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.tree.IElementType");
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final ArrayFactory<IElementType> ARRAY_FACTORY = count2 -> count2 == 0 ? EMPTY_ARRAY : new IElementType[count2];
    public static final Predicate TRUE = type2 -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static short size;
    @NotNull
    private static volatile IElementType[] ourRegistry;
    private static final Object lock;
    private final short myIndex;
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    static IElementType[] push(@NotNull IElementType[] types2) {
        if (types2 == null) {
            IElementType.$$$reportNull$$$0(0);
        }
        Object object = lock;
        // MONITORENTER : object
        IElementType[] oldRegistry = ourRegistry;
        ourRegistry = types2;
        size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
        // MONITOREXIT : object
        if (oldRegistry != null) return oldRegistry;
        IElementType.$$$reportNull$$$0(1);
        return oldRegistry;
    }

    public IElementType(@NotNull String debugName, @Nullable Language language) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(2);
        }
        this(debugName, language, true);
        if (!(this instanceof IFileElementType)) {
            LoadingPhase.assertAtLeast(LoadingPhase.FRAME_SHOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NotNull String debugName, @Nullable Language language, boolean register) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(3);
        }
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                if (this.myIndex >= 15000) {
                    Map<Language, List<IElementType>> byLang = Stream.of(ourRegistry).filter(i -> i != null).collect(Collectors.groupingBy(ie -> ie.myLanguage));
                    Map.Entry max = byLang.entrySet().stream().max(Comparator.comparingInt(e -> ((List)e.getValue()).size())).get();
                    List types2 = (List)max.getValue();
                    LOG.error("Too many element types registered. Out of (short) range. Most of element types (" + types2.size() + ") were registered for '" + max.getKey() + "': " + StringUtil.first(StringUtil.join(types2, ", "), 300, true));
                }
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? ArrayUtil.realloc(ourRegistry, ourRegistry.length * 3 / 2 + 1, ARRAY_FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            IElementType.$$$reportNull$$$0(4);
        }
        return language;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        return ourRegistry[idx];
    }

    @NotNull
    public static IElementType[] enumerate(@NotNull Predicate p) {
        if (p == null) {
            IElementType.$$$reportNull$$$0(5);
        }
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value2 : ourRegistry) {
            if (value2 == null || !p.matches(value2)) continue;
            matches.add(value2);
        }
        IElementType[] iElementTypeArray = matches.toArray(new IElementType[0]);
        if (iElementTypeArray == null) {
            IElementType.$$$reportNull$$$0(6);
        }
        return iElementTypeArray;
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

