/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassTypePointerFactory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTypePointerManagerImpl
extends SmartTypePointerManager {
    private static final SmartTypePointer NULL_POINTER = () -> null;
    private final SmartPointerManager myPsiPointerManager;
    private final Project myProject;

    public SmartTypePointerManagerImpl(SmartPointerManager psiPointerManager, Project project) {
        this.myPsiPointerManager = psiPointerManager;
        this.myProject = project;
    }

    @Override
    @NotNull
    public SmartTypePointer createSmartTypePointer(@NotNull PsiType type2) {
        SmartTypePointer pointer;
        if (type2 == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(0);
        }
        SmartTypePointer smartTypePointer = (pointer = type2.accept(new SmartTypeCreatingVisitor())) != null ? pointer : NULL_POINTER;
        if (smartTypePointer == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(1);
        }
        return smartTypePointer;
    }

    @NotNull
    private SmartTypePointer createClassReferenceTypePointer(@NotNull PsiClassType classType) {
        if (classType == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(2);
        }
        for (ClassTypePointerFactory factory2 : ClassTypePointerFactory.EP_NAME.getExtensions()) {
            SmartTypePointer pointer = factory2.createClassTypePointer(classType, this.myProject);
            if (pointer == null) continue;
            SmartTypePointer smartTypePointer = pointer;
            if (smartTypePointer == null) {
                SmartTypePointerManagerImpl.$$$reportNull$$$0(3);
            }
            return smartTypePointer;
        }
        SimpleTypePointer simpleTypePointer = new SimpleTypePointer(classType);
        if (simpleTypePointer == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(4);
        }
        return simpleTypePointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartTypePointer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassReferenceTypePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSmartTypePointer";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClassReferenceTypePointer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class SmartTypeCreatingVisitor
    extends PsiTypeVisitor<SmartTypePointer> {
        private SmartTypeCreatingVisitor() {
        }

        @Override
        public SmartTypePointer visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return new SimpleTypePointer(primitiveType);
        }

        @Override
        public SmartTypePointer visitArrayType(PsiArrayType arrayType) {
            SmartTypePointer componentTypePointer = arrayType.getComponentType().accept(this);
            return componentTypePointer != null ? new ArrayTypePointer(arrayType, componentTypePointer) : null;
        }

        @Override
        public SmartTypePointer visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            SmartTypePointer boundPointer = bound == null ? null : bound.accept(this);
            return new WildcardTypePointer(wildcardType, boundPointer);
        }

        @Override
        public SmartTypePointer visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 == null) {
                return SmartTypePointerManagerImpl.this.createClassReferenceTypePointer(classType);
            }
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            HashMap<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> pointerMap = new HashMap<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer>();
            HashMap<PsiTypeParameter, PsiType> map2 = new HashMap<PsiTypeParameter, PsiType>();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
                PsiType substitutionResult = substitutor2.substitute(typeParameter);
                if (substitutionResult != null) {
                    SmartPsiElementPointer<PsiTypeParameter> pointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(typeParameter);
                    SmartTypePointer typePointer = substitutionResult.accept(this);
                    pointerMap.put(pointer, typePointer);
                    map2.put(typeParameter, typePointer.getType());
                    continue;
                }
                map2.put(typeParameter, null);
            }
            SmartPsiElementPointer[] annotationPointers = (SmartPsiElementPointer[])Stream.of(classType.getAnnotations()).map(SmartTypePointerManagerImpl.this.myPsiPointerManager::createSmartPsiElementPointer).toArray(SmartPsiElementPointer[]::new);
            LanguageLevel languageLevel = classType.getLanguageLevel();
            return new ClassTypePointer(new PsiImmediateClassType(aClass2, PsiSubstitutorImpl.createSubstitutor(map2), languageLevel, classType.getAnnotations()), SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(aClass2), languageLevel, pointerMap, annotationPointers);
        }

        @Override
        public SmartTypePointer visitDisjunctionType(PsiDisjunctionType disjunctionType) {
            return new DisjunctionTypePointer(disjunctionType);
        }
    }

    private class DisjunctionTypePointer
    extends TypePointerBase<PsiDisjunctionType> {
        private final List<SmartTypePointer> myPointers;

        private DisjunctionTypePointer(PsiDisjunctionType type2) {
            if (type2 == null) {
                DisjunctionTypePointer.$$$reportNull$$$0(0);
            }
            super(type2);
            this.myPointers = ContainerUtil.map(type2.getDisjunctions(), SmartTypePointerManagerImpl.this::createSmartTypePointer);
        }

        @Override
        protected PsiDisjunctionType calcType() {
            List<PsiType> types2 = ContainerUtil.map(this.myPointers, SmartTypePointer::getType);
            return new PsiDisjunctionType(types2, PsiManager.getInstance(SmartTypePointerManagerImpl.this.myProject));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$DisjunctionTypePointer", "<init>"));
        }
    }

    private static class ClassTypePointer
    extends TypePointerBase<PsiClassType> {
        private final SmartPsiElementPointer myClass;
        private final LanguageLevel myLevel;
        private final Map<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> myMap;
        private final SmartPsiElementPointer[] myAnnotations;

        ClassTypePointer(@NotNull PsiClassType type2, @NotNull SmartPsiElementPointer aClass2, @NotNull LanguageLevel languageLevel, @NotNull Map<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> map2, @NotNull SmartPsiElementPointer[] annotations2) {
            if (type2 == null) {
                ClassTypePointer.$$$reportNull$$$0(0);
            }
            if (aClass2 == null) {
                ClassTypePointer.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                ClassTypePointer.$$$reportNull$$$0(2);
            }
            if (map2 == null) {
                ClassTypePointer.$$$reportNull$$$0(3);
            }
            if (annotations2 == null) {
                ClassTypePointer.$$$reportNull$$$0(4);
            }
            super(type2);
            this.myClass = aClass2;
            this.myLevel = languageLevel;
            this.myMap = map2;
            this.myAnnotations = annotations2;
        }

        @Override
        protected PsiClassType calcType() {
            Object classElement = this.myClass.getElement();
            if (!(classElement instanceof PsiClass)) {
                return null;
            }
            HashMap<PsiTypeParameter, PsiType> resurrected = new HashMap<PsiTypeParameter, PsiType>();
            Set<Map.Entry<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer>> set = this.myMap.entrySet();
            for (Map.Entry<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> entry : set) {
                PsiTypeParameter element = entry.getKey().getElement();
                if (element == null) continue;
                SmartTypePointer typePointer = entry.getValue();
                resurrected.put(element, typePointer == null ? null : typePointer.getType());
            }
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiClass)classElement)) {
                if (resurrected.containsKey(typeParameter)) continue;
                resurrected.put(typeParameter, null);
            }
            PsiSubstitutor resurrectedSubstitutor = PsiSubstitutorImpl.createSubstitutor(resurrected);
            PsiAnnotation[] resurrectedAnnotations = (PsiAnnotation[])Stream.of(this.myAnnotations).map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).toArray(PsiAnnotation[]::new);
            return new PsiImmediateClassType((PsiClass)classElement, resurrectedSubstitutor, this.myLevel, resurrectedAnnotations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "map";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotations";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WildcardTypePointer
    extends TypePointerBase<PsiWildcardType> {
        private final PsiManager myManager;
        private final SmartTypePointer myBoundPointer;
        private final boolean myIsExtending;

        WildcardTypePointer(@NotNull PsiWildcardType type2, @Nullable SmartTypePointer boundPointer) {
            if (type2 == null) {
                WildcardTypePointer.$$$reportNull$$$0(0);
            }
            super(type2);
            this.myManager = type2.getManager();
            this.myBoundPointer = boundPointer;
            this.myIsExtending = type2.isExtends();
        }

        @Override
        protected PsiWildcardType calcType() {
            if (this.myBoundPointer == null) {
                return PsiWildcardType.createUnbounded(this.myManager);
            }
            PsiType type2 = this.myBoundPointer.getType();
            assert (type2 != null) : this.myBoundPointer;
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends(this.myManager, type2);
            }
            return PsiWildcardType.createSuper(this.myManager, type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$WildcardTypePointer", "<init>"));
        }
    }

    private static class ArrayTypePointer
    extends TypePointerBase<PsiArrayType> {
        private final SmartTypePointer myComponentTypePointer;

        ArrayTypePointer(@NotNull PsiArrayType type2, @NotNull SmartTypePointer componentTypePointer) {
            if (type2 == null) {
                ArrayTypePointer.$$$reportNull$$$0(0);
            }
            if (componentTypePointer == null) {
                ArrayTypePointer.$$$reportNull$$$0(1);
            }
            super(type2);
            this.myComponentTypePointer = componentTypePointer;
        }

        @Override
        @Nullable
        protected PsiArrayType calcType() {
            PsiType type2 = this.myComponentTypePointer.getType();
            return type2 == null ? null : new PsiArrayType(type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTypePointer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ArrayTypePointer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SimpleTypePointer
    implements SmartTypePointer {
        private final PsiType myType;

        private SimpleTypePointer(@NotNull PsiType type2) {
            if (type2 == null) {
                SimpleTypePointer.$$$reportNull$$$0(0);
            }
            this.myType = type2;
        }

        @Override
        public PsiType getType() {
            return this.myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$SimpleTypePointer", "<init>"));
        }
    }
}

