/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ColorKey
implements Comparable<ColorKey> {
    public static final Key<Function<ColorKey, Color>> FUNCTION_KEY = Key.create("COLOR_KEY_FUNCTION");
    private static final ConcurrentMap<String, ColorKey> ourRegistry = new ConcurrentHashMap<String, ColorKey>();
    @NotNull
    private final String myExternalName;
    private final Color myDefaultColor;

    private ColorKey(@NotNull String externalName, Color defaultColor) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(0);
        }
        this.myExternalName = externalName;
        this.myDefaultColor = defaultColor;
    }

    @NotNull
    public static ColorKey find(@NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(1);
        }
        ColorKey colorKey = ourRegistry.computeIfAbsent(externalName, name -> new ColorKey((String)name, null));
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(2);
        }
        return colorKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull ColorKey key) {
        if (key == null) {
            ColorKey.$$$reportNull$$$0(4);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(5);
        }
        ColorKey colorKey = ColorKey.find(externalName);
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(6);
        }
        return colorKey;
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ColorKey && this.myExternalName.equals(((ColorKey)obj).myExternalName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/ColorKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/ColorKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createColorKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

