/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.MigrationDiagnostics;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002JE\u0010\u0015\u001a\u00020\u0004\"\f\b\u0000\u0010\u0016*\u0006\u0012\u0002\b\u00030\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00192\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00040\u001bH\u0082\bJ\f\u0010\u001c\u001a\u00020\u001d*\u00020\rH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AssigningNamedArgumentToVarargChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkAssignmentOfSingleElementInAnnotation", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkAssignmentOfSingleElementInFunction", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "checkAssignmentOfSingleElementToVararg", "reportMigrationDiagnostic", "T", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "migrationDiagnostics", "Lorg/jetbrains/kotlin/resolve/calls/checkers/MigrationDiagnostics;", "report", "Lkotlin/Function1;", "hasSpread", "", "Companion", "frontend"})
public final class AssigningNamedArgumentToVarargChecker
implements CallChecker {
    private static final MigrationDiagnostics<DiagnosticFactory1<KtExpression, KotlinType>> migrationDiagnosticsForFunction;
    private static final MigrationDiagnostics<DiagnosticFactory0<KtExpression>> migrationDiagnosticsForAnnotation;
    public static final Companion Companion;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedArgument;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument resolvedValueArgument = resolvedArgument = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"resolvedArgument");
            Iterator<ValueArgument> iterator3 = resolvedValueArgument.getArguments().iterator();
            while (iterator3.hasNext()) {
                ValueArgument argument;
                ValueArgument valueArgument = argument = iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument");
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameterDescriptor");
                this.checkAssignmentOfSingleElementToVararg(valueArgument, valueParameterDescriptor, context.getResolutionContext());
            }
        }
    }

    private final void checkAssignmentOfSingleElementToVararg(ValueArgument argument, ValueParameterDescriptor parameterDescriptor, ResolutionContext<?> context) {
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return;
        }
        if (!argument.isNamed()) {
            return;
        }
        if (!ArgumentsUtilsKt.isVararg(parameterDescriptor)) {
            return;
        }
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor)) {
            this.checkAssignmentOfSingleElementInAnnotation(argument, argumentExpression, context);
        } else {
            this.checkAssignmentOfSingleElementInFunction(argument, argumentExpression, context, parameterDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAssignmentOfSingleElementInAnnotation(ValueArgument argument, KtExpression argumentExpression, ResolutionContext<?> context) {
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        if (CallResolverUtilKt.isArrayOrArrayLiteral(argument, bindingTrace)) {
            if (this.hasSpread(argument)) {
                context.trace.report(Errors.REDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        } else {
            MigrationDiagnostics<DiagnosticFactory0<KtExpression>> migrationDiagnostics$iv;
            AssigningNamedArgumentToVarargChecker assigningNamedArgumentToVarargChecker = this;
            MigrationDiagnostics<DiagnosticFactory0<KtExpression>> migrationDiagnostics = migrationDiagnostics$iv = migrationDiagnosticsForAnnotation;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = migrationDiagnostics.component1();
            DiagnosticFactory0<KtExpression> error$iv = migrationDiagnostics.component2();
            if (context.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm)) {
                DiagnosticFactory0<KtExpression> diagnostic = error$iv;
                context.trace.report(diagnostic.on((KtExpression)((PsiElement)argumentExpression)));
            } else {
                void warning$iv;
                DiagnosticFactory0 diagnostic = (DiagnosticFactory0)warning$iv;
                context.trace.report(diagnostic.on((PsiElement)argumentExpression));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAssignmentOfSingleElementInFunction(ValueArgument argument, KtExpression argumentExpression, ResolutionContext<?> context, ValueParameterDescriptor parameterDescriptor) {
        if (!this.hasSpread(argument)) {
            MigrationDiagnostics<DiagnosticFactory1<KtExpression, KotlinType>> migrationDiagnostics$iv;
            AssigningNamedArgumentToVarargChecker assigningNamedArgumentToVarargChecker = this;
            MigrationDiagnostics<DiagnosticFactory1<KtExpression, KotlinType>> migrationDiagnostics = migrationDiagnostics$iv = migrationDiagnosticsForFunction;
            DiagnosticFactory1<KtExpression, KotlinType> diagnosticFactory1 = migrationDiagnostics.component1();
            DiagnosticFactory1<KtExpression, KotlinType> error$iv = migrationDiagnostics.component2();
            if (context.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm)) {
                DiagnosticFactory1<KtExpression, KotlinType> diagnostic = error$iv;
                context.trace.report(diagnostic.on((KtExpression)((PsiElement)argumentExpression), parameterDescriptor.getType()));
            } else {
                void warning$iv;
                DiagnosticFactory1 diagnostic = (DiagnosticFactory1)warning$iv;
                context.trace.report(diagnostic.on((PsiElement)argumentExpression, parameterDescriptor.getType()));
            }
        }
    }

    private final boolean hasSpread(@NotNull ValueArgument $receiver) {
        return $receiver.getSpreadElement() != null;
    }

    static {
        Companion = new Companion(null);
        migrationDiagnosticsForFunction = new MigrationDiagnostics<DiagnosticFactory>(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION, Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION_ERROR);
        migrationDiagnosticsForAnnotation = new MigrationDiagnostics<DiagnosticFactory>(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION, Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION_ERROR);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\b\u001aH\u0012D\u0012B\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AssigningNamedArgumentToVarargChecker$Companion;", "", "()V", "migrationDiagnosticsForAnnotation", "Lorg/jetbrains/kotlin/resolve/calls/checkers/MigrationDiagnostics;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.jvm.PlatformType", "migrationDiagnosticsForFunction", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

