/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Script
extends Action {
    private static final long serialVersionUID = 1L;
    protected String expression;
    protected Set variableAccesses;
    private static final Log log = LogFactory.getLog(Script.class);

    public void read(Element scriptElement, JpdlXmlReader jpdlReader) {
        if (scriptElement.isTextOnly()) {
            this.expression = scriptElement.getTextTrim();
        } else {
            this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(scriptElement));
            this.expression = scriptElement.element("expression").getTextTrim();
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        Map outputMap = this.eval(executionContext);
        this.setVariables(outputMap, executionContext);
    }

    public String toString() {
        return "Script(" + this.expression + ')';
    }

    public Map eval(Token token) {
        return this.eval(new ExecutionContext(token));
    }

    public Map eval(ExecutionContext executionContext) {
        Map inputMap = this.createInputMap(executionContext);
        Set outputNames = this.getOutputNames();
        return this.eval(inputMap, outputNames);
    }

    public Map createInputMap(ExecutionContext executionContext) {
        HashMap<String, Object> inputMap;
        block3: {
            ContextInstance contextInstance;
            Token token;
            block2: {
                token = executionContext.getToken();
                inputMap = new HashMap<String, Object>();
                inputMap.put("executionContext", executionContext);
                inputMap.put("token", token);
                inputMap.put("node", executionContext.getNode());
                inputMap.put("task", executionContext.getTask());
                inputMap.put("taskInstance", executionContext.getTaskInstance());
                contextInstance = executionContext.getContextInstance();
                if (this.hasReadableVariable()) break block2;
                Map variables = contextInstance.getVariables(token);
                if (variables == null) break block3;
                for (Map.Entry entry : variables.entrySet()) {
                    String variableName = (String)entry.getKey();
                    Object variableValue = entry.getValue();
                    inputMap.put(variableName, variableValue);
                }
                break block3;
            }
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                String mappedName = variableAccess.getMappedName();
                Object variableValue = contextInstance.getVariable(variableName, token);
                inputMap.put(mappedName, variableValue);
            }
        }
        return inputMap;
    }

    public Map eval(Map inputMap, Set outputNames) {
        try {
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debug((Object)("script input: " + inputMap));
            }
            Interpreter interpreter = new Interpreter();
            for (Map.Entry entry : inputMap.entrySet()) {
                interpreter.set((String)entry.getKey(), entry.getValue());
            }
            interpreter.eval(this.expression);
            if (outputNames.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, Object> outputMap = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                Object outputValue = interpreter.get(outputName);
                outputMap.put(outputName, outputValue);
            }
            if (debug) {
                log.debug((Object)("script output: " + outputMap));
            }
            return outputMap;
        }
        catch (ParseException e) {
            throw new DelegationException("failed to parse script", e);
        }
        catch (TargetError e) {
            throw new DelegationException("script threw exception", e.getTarget());
        }
        catch (EvalError e) {
            throw new DelegationException("script evaluation halted", e);
        }
    }

    public void addVariableAccess(VariableAccess variableAccess) {
        if (this.variableAccesses == null) {
            this.variableAccesses = new HashSet();
        }
        this.variableAccesses.add(variableAccess);
    }

    private Set getOutputNames() {
        if (this.variableAccesses == null || this.variableAccesses.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> outputNames = new HashSet<String>();
        for (VariableAccess variableAccess : this.variableAccesses) {
            if (!variableAccess.isWritable()) continue;
            outputNames.add(variableAccess.getMappedName());
        }
        return outputNames;
    }

    private boolean hasReadableVariable() {
        if (this.variableAccesses != null) {
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                return true;
            }
        }
        return false;
    }

    private void setVariables(Map outputMap, ExecutionContext executionContext) {
        if (this.variableAccesses == null) {
            return;
        }
        ContextInstance contextInstance = executionContext.getContextInstance();
        Token token = executionContext.getToken();
        for (VariableAccess variableAccess : this.variableAccesses) {
            if (!variableAccess.isWritable()) continue;
            Object value = outputMap.get(variableAccess.getMappedName());
            contextInstance.setVariable(variableAccess.getVariableName(), value, token);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Set getVariableAccesses() {
        return this.variableAccesses;
    }

    public void setVariableAccesses(Set variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

