/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class PropertyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String setterMethodName;
    private final ObjectInfo propertyValueInfo;

    public PropertyInfo(Element propertyElement, ObjectFactoryParser configParser) {
        if (propertyElement.hasAttribute("name")) {
            String propertyName = propertyElement.getAttribute("name");
            this.setterMethodName = propertyName.startsWith("is") && propertyName.length() >= 3 && Character.isUpperCase(propertyName.charAt(2)) ? "set" + propertyName.substring(2) : "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        } else if (propertyElement.hasAttribute("setter")) {
            this.setterMethodName = propertyElement.getAttribute("setter");
        } else {
            throw new JbpmException("missing name or setter attribute in property");
        }
        Element propertyValueElement = XmlUtil.element(propertyElement);
        this.propertyValueInfo = configParser.parse(propertyValueElement);
    }

    public void injectProperty(Object object, ObjectFactoryImpl objectFactory) {
        Object value = objectFactory.getObject(this.propertyValueInfo);
        Method setterMethod = this.findSetter(object.getClass(), value.getClass());
        try {
            setterMethod.invoke(object, value);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + setterMethod, e);
        }
        catch (InvocationTargetException e) {
            throw new JbpmException(setterMethod + " threw exception", e.getCause());
        }
    }

    private Method findSetter(Class type, Class propertyType) {
        Class[] parameterTypes = new Class[]{propertyType};
        try {
            return type.getMethod(this.setterMethodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            for (Class ancestor = type; ancestor != Object.class; ancestor = ancestor.getSuperclass()) {
                try {
                    Method method = type.getDeclaredMethod(this.setterMethodName, parameterTypes);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e2) {
                    continue;
                }
            }
            return this.findSetter(type);
        }
    }

    public Method findSetter(Class type) {
        for (Class ancestor = type; ancestor != Object.class; ancestor = ancestor.getSuperclass()) {
            Method[] methods = ancestor.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(this.setterMethodName) || method.getParameterTypes().length != 1) continue;
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                return method;
            }
        }
        throw new JbpmException("missing setter '" + this.setterMethodName + "' in " + type);
    }
}

