/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jabber;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.workitem.AbstractLogOrThrowWorkItemHandler;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabberWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(JabberWorkItemHandler.class);
    private String user;
    private String password;
    private String server;
    private int port;
    private String service;
    private String text;
    private List<String> toUsers = new ArrayList<String>();

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.user = (String)workItem.getParameter("User");
        this.password = (String)workItem.getParameter("Password");
        this.server = (String)workItem.getParameter("Server");
        String portString = (String)workItem.getParameter("Port");
        if (portString != null && !portString.equals("")) {
            this.port = Integer.valueOf((String)workItem.getParameter("Port"));
        }
        this.service = (String)workItem.getParameter("Service");
        this.text = (String)workItem.getParameter("Text");
        String to = (String)workItem.getParameter("To");
        if (to == null || to.trim().length() == 0) {
            throw new RuntimeException("IM must have one or more to adresses");
        }
        for (String s : to.split(";")) {
            if (s == null || "".equals(s)) continue;
            this.toUsers.add(s);
        }
        ConnectionConfiguration conf = new ConnectionConfiguration(this.server, this.port, this.service);
        XMPPConnection connection = null;
        try {
            connection = this.server != null && !this.server.equals("") && this.port != 0 ? new XMPPConnection(conf) : new XMPPConnection(this.service);
            connection.connect();
            logger.info("Connected to {}", (Object)connection.getHost());
            connection.login(this.user, this.password);
            logger.info("Logged in as {}", (Object)connection.getUser());
            Presence presence = new Presence(Presence.Type.available);
            connection.sendPacket((Packet)presence);
            for (String toUser : this.toUsers) {
                ChatManager chatmanager = connection.getChatManager();
                Chat chat = chatmanager.createChat(toUser, null);
                Message msg = new Message(toUser, Message.Type.chat);
                msg.setBody(this.text);
                chat.sendMessage(msg);
                logger.info("Message Sent {}", (Object)msg);
            }
            connection.disconnect();
            manager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

