/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationEntry {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONVERSATION);
    private ConversationImpl conversation;
    private Future<?> terminationHandle;
    private ReentrantLock concurrencyLock;
    private BeanStore beanStore;

    protected ConversationEntry(BeanStore beanStore, ConversationImpl conversation, Future<?> terminationHandle) {
        this.beanStore = beanStore;
        this.conversation = new ConversationImpl(conversation);
        this.terminationHandle = terminationHandle;
        this.concurrencyLock = new ReentrantLock();
    }

    public static ConversationEntry of(BeanStore beanStore, ConversationImpl conversation, Future<?> terminationHandle) {
        return new ConversationEntry(beanStore, conversation, terminationHandle);
    }

    public boolean cancelTermination() {
        if (this.terminationHandle.isCancelled()) {
            return true;
        }
        boolean success = this.terminationHandle.cancel(false);
        if (success) {
            log.trace(ConversationMessage.CONVERSATION_TERMINATION_CANCELLED, this.conversation);
        } else {
            log.warn(ConversationMessage.CONVERSATION_TERMINATION_CANCELLATION_FAILED, this.conversation);
        }
        return success;
    }

    public void destroy() {
        if (!this.terminationHandle.isCancelled()) {
            this.cancelTermination();
        }
        ConversationContext terminationContext = new ConversationContext();
        terminationContext.setBeanStore(this.beanStore);
        terminationContext.destroy();
    }

    public boolean lock(long timeout) throws InterruptedException {
        boolean success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        if (success) {
            log.trace(ConversationMessage.CONVERSATION_LOCKED, this.conversation);
        } else {
            log.warn(ConversationMessage.CONVERSATION_UNAVAILBLE, timeout, this.conversation);
        }
        return success;
    }

    public boolean unlock() {
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            log.trace(ConversationMessage.CONVERSATION_UNLOCKED, this.conversation);
        } else {
            log.warn(ConversationMessage.ILLEGAL_CONVERSATION_UNLOCK_ATTEMPT, this.conversation, "not owner");
        }
        return !this.concurrencyLock.isLocked();
    }

    public void reScheduleTermination(Future<?> terminationHandle) {
        this.terminationHandle = terminationHandle;
    }

    public ConversationImpl getConversation() {
        return this.conversation;
    }
}

