/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractResource {
    private ServletContext context;

    protected ServletContext getServletContext() {
        return this.context;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public abstract void getResource(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public abstract String getResourcePath();

    protected OutputStream selectOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        String mimeType = response.getContentType();
        if (this.isGzipEnabled() && acceptEncoding != null && acceptEncoding.length() > 0 && acceptEncoding.indexOf("gzip") > -1 && this.isCompressedMimeType(mimeType)) {
            return new GZIPResponseStream(response);
        }
        return response.getOutputStream();
    }

    protected boolean isCompressedMimeType(String mimeType) {
        return mimeType.matches("text/.+");
    }

    protected boolean isGzipEnabled() {
        return true;
    }

    private class GZIPResponseStream
    extends ServletOutputStream {
        private ByteArrayOutputStream byteStream = null;
        private GZIPOutputStream gzipStream = null;
        private boolean closed = false;
        private HttpServletResponse response = null;
        private ServletOutputStream servletStream = null;

        public GZIPResponseStream(HttpServletResponse response) throws IOException {
            this.response = response;
            this.servletStream = response.getOutputStream();
            this.byteStream = new ByteArrayOutputStream();
            this.gzipStream = new GZIPOutputStream(this.byteStream);
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("This output stream has already been closed");
            }
            this.gzipStream.finish();
            byte[] bytes = this.byteStream.toByteArray();
            this.response.setContentLength(bytes.length);
            this.response.addHeader("Content-Encoding", "gzip");
            this.servletStream.write(bytes);
            this.servletStream.flush();
            this.servletStream.close();
            this.closed = true;
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush a closed output stream");
            }
            this.gzipStream.flush();
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed output stream");
            }
            this.gzipStream.write((byte)b);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed output stream");
            }
            this.gzipStream.write(b, off, len);
        }

        public boolean closed() {
            return this.closed;
        }

        public void reset() {
        }
    }
}

