/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Method;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.transaction.Synchronization;
import org.jboss.seam.Entity;
import org.jboss.seam.persistence.EntityManagerProxy;
import org.jboss.seam.persistence.Filter;

public abstract class AbstractPersistenceProvider {
    public abstract void setFlushModeManual(EntityManager var1);

    public abstract boolean isDirty(EntityManager var1);

    public Object getId(Object bean, EntityManager entityManager) {
        return Entity.forClass(bean.getClass()).getIdentifier(bean);
    }

    public String getName(Object bean, EntityManager entityManager) throws IllegalArgumentException {
        return Entity.forClass(bean.getClass()).getName();
    }

    public Object getVersion(Object bean, EntityManager entityManager) {
        return Entity.forClass(bean.getClass()).getVersion(bean);
    }

    public void checkVersion(Object bean, EntityManager entityManager, Object oldVersion, Object version) {
        boolean equal = oldVersion instanceof Date ? ((Date)oldVersion).getTime() == ((Date)version).getTime() : oldVersion.equals(version);
        if (!equal) {
            throw new OptimisticLockException("current database version number does not match passivated version number");
        }
    }

    public abstract void enableFilter(Filter var1, EntityManager var2);

    public abstract boolean registerSynchronization(Synchronization var1, EntityManager var2);

    public Object proxyDelegate(Object delegate) {
        return delegate;
    }

    public EntityManager proxyEntityManager(EntityManager entityManager) {
        return new EntityManagerProxy(entityManager);
    }

    public Class getBeanClass(Object bean) {
        return Entity.forClass(bean.getClass()).getBeanClass();
    }

    public Method getPostLoadMethod(Class beanClass, EntityManager entityManager) {
        return Entity.forClass(beanClass).getPostLoadMethod();
    }

    public Method getPrePersistMethod(Class beanClass, EntityManager entityManager) {
        return Entity.forClass(beanClass).getPrePersistMethod();
    }

    public Method getPreUpdateMethod(Class beanClass, EntityManager entityManager) {
        return Entity.forClass(beanClass).getPreUpdateMethod();
    }

    public Method getPreRemoveMethod(Class beanClass, EntityManager entityManager) {
        return Entity.forClass(beanClass).getPreRemoveMethod();
    }
}

