/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.jmx.JBossClusterMonitor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class SeamListener
implements ServletContextListener,
HttpSessionListener {
    private static final LogProvider log = Logging.getLogProvider(ServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        log.info("Welcome to Seam " + Seam.getVersion());
        ServletLifecycle.beginApplication(event.getServletContext());
        new Initialization(event.getServletContext()).create().init();
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletLifecycle.endApplication();
    }

    public void sessionCreated(HttpSessionEvent event) {
        ServletLifecycle.beginSession(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        JBossClusterMonitor monitor = JBossClusterMonitor.getInstance(event.getSession().getServletContext());
        if (monitor != null && monitor.failover()) {
            log.info("Detected fail-over, not destroying session context");
        } else {
            ServletLifecycle.endSession(event.getSession());
        }
    }
}

